#ifndef CUFFTDX_FFT_625_FP32_INV_PTX_HPP
#define CUFFTDX_FFT_625_FP32_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<365, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1717>;
.reg .b32 r<14>;
.reg .b64 rd<9>;
mov.u32 r12, %tid.y;
mov.u32 r13, %50;
mad.lo.s32 r3, r12, 5000, r13;
add.f32 f101, %62, %92;
add.f32 f103, %72, %82;
add.f32 f1716, %52, f101;
add.f32 f104, f103, f1716;
add.f32 f105, %102, %104;
add.f32 f107, %103, %83;
add.f32 f1712, %53, f105;
add.f32 f108, f107, f1712;
mul.f32 f110, f103, 0f3F4F1BBD;
fma.rn.f32 f1711, f101, 0f3E9E377A, %52;
sub.f32 f111, f1711, f110;
sub.f32 f112, %102, %104;
sub.f32 f114, %103, %83;
mul.f32 f1710, f112, 0f3F737871;
fma.rn.f32 f115, f114, 0f3F167918, f1710;
sub.f32 f116, f111, f115;
add.f32 f117, f115, f111;
mul.f32 f118, f101, 0f3F4F1BBD;
sub.f32 f119, %52, f118;
fma.rn.f32 f120, f103, 0f3E9E377A, f119;
mul.f32 f121, f112, 0f3F167918;
mul.f32 f122, f114, 0f3F737871;
sub.f32 f123, f121, f122;
sub.f32 f124, f120, f123;
add.f32 f125, f123, f120;
mul.f32 f127, f107, 0f3F4F1BBD;
fma.rn.f32 f1709, f105, 0f3E9E377A, %53;
sub.f32 f128, f1709, f127;
sub.f32 f129, %62, %92;
sub.f32 f131, %72, %82;
mul.f32 f1708, f129, 0f3F737871;
fma.rn.f32 f132, f131, 0f3F167918, f1708;
add.f32 f133, f132, f128;
sub.f32 f134, f128, f132;
mul.f32 f135, f105, 0f3F4F1BBD;
sub.f32 f136, %53, f135;
fma.rn.f32 f137, f107, 0f3E9E377A, f136;
mul.f32 f138, f129, 0f3F167918;
mul.f32 f139, f131, 0f3F737871;
sub.f32 f140, f138, f139;
add.f32 f141, f140, f137;
sub.f32 f142, f137, f140;
add.f32 f143, %64, %94;
add.f32 f145, %74, %84;
add.f32 f1707, %54, f143;
add.f32 f146, f145, f1707;
add.f32 f147, %65, %95;
add.f32 f149, %107, %105;
add.f32 f1703, %106, f147;
add.f32 f150, f149, f1703;
fma.rn.f32 f1701, f143, 0f3E9E377A, %54;
mul.f32 f1702, f145, 0f3F4F1BBD;
sub.f32 f153, f1701, f1702;
sub.f32 f154, %65, %95;
sub.f32 f156, %107, %105;
mul.f32 f1700, f154, 0f3F737871;
fma.rn.f32 f157, f156, 0f3F167918, f1700;
sub.f32 f158, f153, f157;
add.f32 f159, f157, f153;
mul.f32 f160, f143, 0f3F4F1BBD;
sub.f32 f161, %54, f160;
fma.rn.f32 f162, f145, 0f3E9E377A, f161;
mul.f32 f163, f154, 0f3F167918;
mul.f32 f164, f156, 0f3F737871;
sub.f32 f165, f163, f164;
sub.f32 f166, f162, f165;
add.f32 f167, f165, f162;
mul.f32 f169, f149, 0f3F4F1BBD;
fma.rn.f32 f1699, f147, 0f3E9E377A, %106;
sub.f32 f170, f1699, f169;
sub.f32 f171, %64, %94;
sub.f32 f173, %74, %84;
mul.f32 f1698, f171, 0f3F737871;
fma.rn.f32 f174, f173, 0f3F167918, f1698;
add.f32 f175, f174, f170;
sub.f32 f176, f170, f174;
mul.f32 f177, f147, 0f3F4F1BBD;
sub.f32 f178, %106, f177;
fma.rn.f32 f179, f149, 0f3E9E377A, f178;
mul.f32 f180, f171, 0f3F167918;
mul.f32 f181, f173, 0f3F737871;
sub.f32 f182, f180, f181;
add.f32 f183, f182, f179;
sub.f32 f184, f179, f182;
add.f32 f185, %66, %96;
add.f32 f187, %76, %86;
add.f32 f1697, %56, f185;
add.f32 f188, f187, f1697;
add.f32 f189, %110, %109;
add.f32 f191, %77, %111;
add.f32 f1692, %108, f189;
add.f32 f192, f191, f1692;
fma.rn.f32 f1690, f185, 0f3E9E377A, %56;
mul.f32 f1691, f187, 0f3F4F1BBD;
sub.f32 f195, f1690, f1691;
sub.f32 f196, %110, %109;
sub.f32 f198, %77, %111;
mul.f32 f1689, f196, 0f3F737871;
fma.rn.f32 f199, f198, 0f3F167918, f1689;
sub.f32 f200, f195, f199;
add.f32 f201, f199, f195;
mul.f32 f202, f185, 0f3F4F1BBD;
sub.f32 f203, %56, f202;
fma.rn.f32 f204, f187, 0f3E9E377A, f203;
mul.f32 f205, f196, 0f3F167918;
mul.f32 f206, f198, 0f3F737871;
sub.f32 f207, f205, f206;
sub.f32 f208, f204, f207;
add.f32 f209, f207, f204;
fma.rn.f32 f1687, f189, 0f3E9E377A, %108;
mul.f32 f1688, f191, 0f3F4F1BBD;
sub.f32 f212, f1687, f1688;
sub.f32 f213, %66, %96;
sub.f32 f215, %76, %86;
mul.f32 f1686, f213, 0f3F737871;
fma.rn.f32 f216, f215, 0f3F167918, f1686;
add.f32 f217, f216, f212;
sub.f32 f218, f212, f216;
mul.f32 f219, f189, 0f3F4F1BBD;
sub.f32 f220, %108, f219;
fma.rn.f32 f221, f191, 0f3E9E377A, f220;
mul.f32 f222, f213, 0f3F167918;
mul.f32 f223, f215, 0f3F737871;
sub.f32 f224, f222, f223;
add.f32 f225, f224, f221;
sub.f32 f226, f221, f224;
add.f32 f227, %68, %98;
add.f32 f229, %78, %88;
add.f32 f1685, %58, f227;
add.f32 f230, f229, f1685;
add.f32 f231, %113, %112;
add.f32 f233, %114, %89;
add.f32 f1681, %59, f231;
add.f32 f234, f233, f1681;
mul.f32 f236, f229, 0f3F4F1BBD;
fma.rn.f32 f1680, f227, 0f3E9E377A, %58;
sub.f32 f237, f1680, f236;
sub.f32 f238, %113, %112;
sub.f32 f240, %114, %89;
mul.f32 f1679, f238, 0f3F737871;
fma.rn.f32 f241, f240, 0f3F167918, f1679;
sub.f32 f242, f237, f241;
add.f32 f243, f241, f237;
mul.f32 f244, f227, 0f3F4F1BBD;
sub.f32 f245, %58, f244;
fma.rn.f32 f246, f229, 0f3E9E377A, f245;
mul.f32 f247, f238, 0f3F167918;
mul.f32 f248, f240, 0f3F737871;
sub.f32 f249, f247, f248;
sub.f32 f250, f246, f249;
add.f32 f251, f249, f246;
mul.f32 f253, f233, 0f3F4F1BBD;
fma.rn.f32 f1678, f231, 0f3E9E377A, %59;
sub.f32 f254, f1678, f253;
sub.f32 f255, %68, %98;
sub.f32 f257, %78, %88;
mul.f32 f1677, f255, 0f3F737871;
fma.rn.f32 f258, f257, 0f3F167918, f1677;
add.f32 f259, f258, f254;
sub.f32 f260, f254, f258;
mul.f32 f261, f231, 0f3F4F1BBD;
sub.f32 f262, %59, f261;
fma.rn.f32 f263, f233, 0f3E9E377A, f262;
mul.f32 f264, f255, 0f3F167918;
mul.f32 f265, f257, 0f3F737871;
sub.f32 f266, f264, f265;
add.f32 f267, f266, f263;
sub.f32 f268, f263, f266;
add.f32 f269, %70, %100;
add.f32 f271, %80, %90;
add.f32 f1676, %60, f269;
add.f32 f272, f271, f1676;
add.f32 f273, %71, %101;
add.f32 f275, %117, %115;
add.f32 f1672, %116, f273;
add.f32 f276, f275, f1672;
mul.f32 f278, f271, 0f3F4F1BBD;
fma.rn.f32 f1671, f269, 0f3E9E377A, %60;
sub.f32 f279, f1671, f278;
sub.f32 f280, %71, %101;
sub.f32 f282, %117, %115;
mul.f32 f1670, f280, 0f3F737871;
fma.rn.f32 f283, f282, 0f3F167918, f1670;
sub.f32 f284, f279, f283;
add.f32 f285, f283, f279;
mul.f32 f286, f269, 0f3F4F1BBD;
sub.f32 f287, %60, f286;
fma.rn.f32 f288, f271, 0f3E9E377A, f287;
mul.f32 f289, f280, 0f3F167918;
mul.f32 f290, f282, 0f3F737871;
sub.f32 f291, f289, f290;
sub.f32 f292, f288, f291;
add.f32 f293, f291, f288;
mul.f32 f295, f275, 0f3F4F1BBD;
fma.rn.f32 f1669, f273, 0f3E9E377A, %116;
sub.f32 f296, f1669, f295;
sub.f32 f297, %70, %100;
sub.f32 f299, %80, %90;
mul.f32 f1668, f297, 0f3F737871;
fma.rn.f32 f300, f299, 0f3F167918, f1668;
add.f32 f301, f300, f296;
sub.f32 f302, f296, f300;
mul.f32 f303, f273, 0f3F4F1BBD;
sub.f32 f304, %116, f303;
fma.rn.f32 f305, f275, 0f3E9E377A, f304;
mul.f32 f306, f297, 0f3F167918;
mul.f32 f307, f299, 0f3F737871;
sub.f32 f308, f306, f307;
add.f32 f309, f308, f305;
sub.f32 f310, f305, f308;
mul.f32 f1666, f158, 0f3F77F511;
mul.f32 f1667, f175, 0f3E7EA890;
sub.f32 f313, f1666, f1667;
mul.f32 f314, f175, 0f3F77F511;
fma.rn.f32 f315, f158, 0f3E7EA890, f314;
mul.f32 f1664, f200, 0f3F6055A2;
mul.f32 f1665, f217, 0f3EF6A86B;
sub.f32 f318, f1664, f1665;
mul.f32 f319, f217, 0f3F6055A2;
fma.rn.f32 f320, f200, 0f3EF6A86B, f319;
mul.f32 f322, f259, 0f3F2F3E7B;
mul.f32 f1663, f242, 0f3F3A9DB0;
sub.f32 f323, f1663, f322;
mul.f32 f324, f259, 0f3F3A9DB0;
fma.rn.f32 f325, f242, 0f3F2F3E7B, f324;
mul.f32 f327, f301, 0f3F5825E0;
mul.f32 f1662, f284, 0f3F092BF2;
sub.f32 f328, f1662, f327;
mul.f32 f329, f301, 0f3F092BF2;
fma.rn.f32 f330, f284, 0f3F5825E0, f329;
mul.f32 f332, f183, 0f3EF6A86B;
mul.f32 f1661, f166, 0f3F6055A2;
sub.f32 f333, f1661, f332;
mul.f32 f334, f183, 0f3F6055A2;
fma.rn.f32 f335, f166, 0f3EF6A86B, f334;
mul.f32 f337, f225, 0f3F5825E0;
mul.f32 f1660, f208, 0f3F092BF2;
sub.f32 f338, f1660, f337;
mul.f32 f339, f225, 0f3F092BF2;
fma.rn.f32 f340, f208, 0f3F5825E0, f339;
mul.f32 f342, f267, 0f3F7F7EAE;
mul.f32 f1659, f250, 0f3D809851;
sub.f32 f343, f1659, f342;
mul.f32 f344, f267, 0f3D809851;
fma.rn.f32 f345, f250, 0f3F7F7EAE, f344;
mul.f32 f1657, f292, 0fBED9FFBE;
mul.f32 f1658, f309, 0f3F67A2BF;
sub.f32 f348, f1657, f1658;
mul.f32 f349, f309, 0fBED9FFBE;
fma.rn.f32 f350, f292, 0f3F67A2BF, f349;
mul.f32 f1655, f167, 0f3F3A9DB0;
mul.f32 f1656, f184, 0f3F2F3E7B;
sub.f32 f353, f1655, f1656;
mul.f32 f354, f184, 0f3F3A9DB0;
fma.rn.f32 f355, f167, 0f3F2F3E7B, f354;
mul.f32 f1653, f209, 0f3D809851;
mul.f32 f1654, f226, 0f3F7F7EAE;
sub.f32 f358, f1653, f1654;
mul.f32 f359, f226, 0f3D809851;
fma.rn.f32 f360, f209, 0f3F7F7EAE, f359;
mul.f32 f1651, f251, 0fBF232E38;
mul.f32 f1652, f268, 0f3F45405B;
sub.f32 f363, f1651, f1652;
mul.f32 f364, f268, 0fBF232E38;
fma.rn.f32 f365, f251, 0f3F45405B, f364;
mul.f32 f367, f310, 0f3E00575B;
mul.f32 f1650, f293, 0fBF7DFB3B;
sub.f32 f368, f1650, f367;
mul.f32 f369, f310, 0fBF7DFB3B;
fma.rn.f32 f370, f293, 0f3E00575B, f369;
mul.f32 f372, f176, 0f3F5825E0;
mul.f32 f1649, f159, 0f3F092BF2;
sub.f32 f373, f1649, f372;
mul.f32 f374, f176, 0f3F092BF2;
fma.rn.f32 f375, f159, 0f3F5825E0, f374;
mul.f32 f377, f218, 0f3F67A2BF;
mul.f32 f1648, f201, 0fBED9FFBE;
sub.f32 f378, f1648, f377;
mul.f32 f379, f218, 0fBED9FFBE;
fma.rn.f32 f380, f201, 0f3F67A2BF, f379;
mul.f32 f382, f260, 0f3E00575B;
mul.f32 f1647, f243, 0fBF7DFB3B;
sub.f32 f383, f1647, f382;
mul.f32 f384, f260, 0fBF7DFB3B;
fma.rn.f32 f385, f243, 0f3E00575B, f384;
mul.f32 f387, f302, 0fBF45405B;
mul.f32 f1646, f285, 0fBF232E38;
sub.f32 f388, f1646, f387;
mul.f32 f389, f302, 0fBF232E38;
fma.rn.f32 f390, f285, 0fBF45405B, f389;
add.f32 f391, f146, f272;
add.f32 f393, f188, f230;
mul.f32 f398, f393, 0f3F4F1BBD;
fma.rn.f32 f1645, f391, 0f3E9E377A, f104;
sub.f32 f399, f1645, f398;
add.f32 f1644, f150, f276;
sub.f32 f400, f150, f276;
add.f32 f1643, f192, f234;
sub.f32 f402, f192, f234;
mul.f32 f1642, f400, 0f3F737871;
fma.rn.f32 f403, f402, 0f3F167918, f1642;
sub.f32 f404, f399, f403;
add.f32 f405, f403, f399;
add.f32 f1641, f104, f391;
mul.f32 f406, f391, 0f3F4F1BBD;
sub.f32 f407, f104, f406;
fma.rn.f32 f408, f393, 0f3E9E377A, f407;
mul.f32 f409, f400, 0f3F167918;
mul.f32 f410, f402, 0f3F737871;
sub.f32 f411, f409, f410;
sub.f32 f412, f408, f411;
add.f32 f413, f411, f408;
mul.f32 f415, f1643, 0f3F4F1BBD;
fma.rn.f32 f1640, f1644, 0f3E9E377A, f108;
sub.f32 f416, f1640, f415;
sub.f32 f417, f146, f272;
sub.f32 f419, f188, f230;
mul.f32 f1639, f417, 0f3F737871;
fma.rn.f32 f420, f419, 0f3F167918, f1639;
add.f32 f421, f420, f416;
sub.f32 f422, f416, f420;
add.f32 f1638, f108, f1644;
mul.f32 f423, f1644, 0f3F4F1BBD;
sub.f32 f424, f108, f423;
fma.rn.f32 f425, f1643, 0f3E9E377A, f424;
mul.f32 f426, f417, 0f3F167918;
mul.f32 f427, f419, 0f3F737871;
sub.f32 f428, f426, f427;
add.f32 f429, f428, f425;
sub.f32 f430, f425, f428;
add.f32 f431, f313, f328;
add.f32 f433, f318, f323;
add.f32 f1637, f116, f431;
add.f32 f434, f433, f1637;
add.f32 f435, f315, f330;
add.f32 f437, f320, f325;
add.f32 f1636, f133, f435;
add.f32 f438, f437, f1636;
fma.rn.f32 f1634, f431, 0f3E9E377A, f116;
mul.f32 f1635, f433, 0f3F4F1BBD;
sub.f32 f441, f1634, f1635;
sub.f32 f442, f315, f330;
sub.f32 f444, f320, f325;
mul.f32 f1633, f442, 0f3F737871;
fma.rn.f32 f445, f444, 0f3F167918, f1633;
sub.f32 f446, f441, f445;
add.f32 f447, f445, f441;
mul.f32 f448, f431, 0f3F4F1BBD;
sub.f32 f449, f116, f448;
fma.rn.f32 f450, f433, 0f3E9E377A, f449;
mul.f32 f451, f442, 0f3F167918;
mul.f32 f452, f444, 0f3F737871;
sub.f32 f453, f451, f452;
sub.f32 f454, f450, f453;
add.f32 f455, f453, f450;
mul.f32 f457, f437, 0f3F4F1BBD;
fma.rn.f32 f1632, f435, 0f3E9E377A, f133;
sub.f32 f458, f1632, f457;
sub.f32 f459, f313, f328;
sub.f32 f461, f318, f323;
mul.f32 f1631, f459, 0f3F737871;
fma.rn.f32 f462, f461, 0f3F167918, f1631;
add.f32 f463, f462, f458;
sub.f32 f464, f458, f462;
mul.f32 f465, f435, 0f3F4F1BBD;
sub.f32 f466, f133, f465;
fma.rn.f32 f467, f437, 0f3E9E377A, f466;
mul.f32 f468, f459, 0f3F167918;
mul.f32 f469, f461, 0f3F737871;
sub.f32 f470, f468, f469;
add.f32 f471, f470, f467;
sub.f32 f472, f467, f470;
add.f32 f473, f333, f348;
add.f32 f475, f338, f343;
add.f32 f1630, f124, f473;
add.f32 f476, f475, f1630;
add.f32 f477, f335, f350;
add.f32 f479, f340, f345;
add.f32 f1629, f141, f477;
add.f32 f480, f479, f1629;
fma.rn.f32 f1627, f473, 0f3E9E377A, f124;
mul.f32 f1628, f475, 0f3F4F1BBD;
sub.f32 f483, f1627, f1628;
sub.f32 f484, f335, f350;
sub.f32 f486, f340, f345;
mul.f32 f1626, f484, 0f3F737871;
fma.rn.f32 f487, f486, 0f3F167918, f1626;
sub.f32 f488, f483, f487;
add.f32 f489, f487, f483;
mul.f32 f490, f473, 0f3F4F1BBD;
sub.f32 f491, f124, f490;
fma.rn.f32 f492, f475, 0f3E9E377A, f491;
mul.f32 f493, f484, 0f3F167918;
mul.f32 f494, f486, 0f3F737871;
sub.f32 f495, f493, f494;
sub.f32 f496, f492, f495;
add.f32 f497, f495, f492;
fma.rn.f32 f1624, f477, 0f3E9E377A, f141;
mul.f32 f1625, f479, 0f3F4F1BBD;
sub.f32 f500, f1624, f1625;
sub.f32 f501, f333, f348;
sub.f32 f503, f338, f343;
mul.f32 f1623, f501, 0f3F737871;
fma.rn.f32 f504, f503, 0f3F167918, f1623;
add.f32 f505, f504, f500;
sub.f32 f506, f500, f504;
mul.f32 f507, f477, 0f3F4F1BBD;
sub.f32 f508, f141, f507;
fma.rn.f32 f509, f479, 0f3E9E377A, f508;
mul.f32 f510, f501, 0f3F167918;
mul.f32 f511, f503, 0f3F737871;
sub.f32 f512, f510, f511;
add.f32 f513, f512, f509;
sub.f32 f514, f509, f512;
add.f32 f515, f353, f368;
add.f32 f517, f358, f363;
add.f32 f1622, f125, f515;
add.f32 f518, f517, f1622;
add.f32 f519, f355, f370;
add.f32 f521, f360, f365;
add.f32 f1621, f142, f519;
add.f32 f522, f521, f1621;
mul.f32 f524, f517, 0f3F4F1BBD;
fma.rn.f32 f1620, f515, 0f3E9E377A, f125;
sub.f32 f525, f1620, f524;
sub.f32 f526, f355, f370;
sub.f32 f528, f360, f365;
mul.f32 f1619, f526, 0f3F737871;
fma.rn.f32 f529, f528, 0f3F167918, f1619;
sub.f32 f530, f525, f529;
add.f32 f531, f529, f525;
mul.f32 f532, f515, 0f3F4F1BBD;
sub.f32 f533, f125, f532;
fma.rn.f32 f534, f517, 0f3E9E377A, f533;
mul.f32 f535, f526, 0f3F167918;
mul.f32 f536, f528, 0f3F737871;
sub.f32 f537, f535, f536;
sub.f32 f538, f534, f537;
add.f32 f539, f537, f534;
mul.f32 f541, f521, 0f3F4F1BBD;
fma.rn.f32 f1618, f519, 0f3E9E377A, f142;
sub.f32 f542, f1618, f541;
sub.f32 f543, f353, f368;
sub.f32 f545, f358, f363;
mul.f32 f1617, f543, 0f3F737871;
fma.rn.f32 f546, f545, 0f3F167918, f1617;
add.f32 f547, f546, f542;
sub.f32 f548, f542, f546;
mul.f32 f549, f519, 0f3F4F1BBD;
sub.f32 f550, f142, f549;
fma.rn.f32 f551, f521, 0f3E9E377A, f550;
mul.f32 f552, f543, 0f3F167918;
mul.f32 f553, f545, 0f3F737871;
sub.f32 f554, f552, f553;
add.f32 f555, f554, f551;
sub.f32 f556, f551, f554;
add.f32 f557, f373, f388;
add.f32 f559, f378, f383;
add.f32 f1616, f117, f557;
add.f32 f560, f559, f1616;
add.f32 f561, f375, f390;
add.f32 f563, f380, f385;
add.f32 f1615, f134, f561;
add.f32 f564, f563, f1615;
mul.f32 f566, f559, 0f3F4F1BBD;
fma.rn.f32 f1614, f557, 0f3E9E377A, f117;
sub.f32 f567, f1614, f566;
sub.f32 f568, f375, f390;
sub.f32 f570, f380, f385;
mul.f32 f1613, f568, 0f3F737871;
fma.rn.f32 f571, f570, 0f3F167918, f1613;
sub.f32 f572, f567, f571;
add.f32 f573, f571, f567;
mul.f32 f574, f557, 0f3F4F1BBD;
sub.f32 f575, f117, f574;
fma.rn.f32 f576, f559, 0f3E9E377A, f575;
mul.f32 f577, f568, 0f3F167918;
mul.f32 f578, f570, 0f3F737871;
sub.f32 f579, f577, f578;
sub.f32 f580, f576, f579;
add.f32 f581, f579, f576;
mul.f32 f583, f563, 0f3F4F1BBD;
fma.rn.f32 f1612, f561, 0f3E9E377A, f134;
sub.f32 f584, f1612, f583;
sub.f32 f585, f373, f388;
sub.f32 f587, f378, f383;
mul.f32 f1611, f585, 0f3F737871;
fma.rn.f32 f588, f587, 0f3F167918, f1611;
add.f32 f589, f588, f584;
sub.f32 f590, f584, f588;
mul.f32 f591, f561, 0f3F4F1BBD;
sub.f32 f592, f134, f591;
fma.rn.f32 f593, f563, 0f3E9E377A, f592;
mul.f32 f594, f585, 0f3F167918;
mul.f32 f595, f587, 0f3F737871;
sub.f32 f596, f594, f595;
add.f32 f597, f596, f593;
sub.f32 f598, f593, f596;
mov.u32 r11, %tid.x;
mul.wide.u32 rd2, r11, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r11, r6;
mad.lo.s32 r8, r5, 5000, r3;
mul.wide.u32 rd7, r7, 8;
mov.u64 rd8, %51;
add.s64 rd6, rd8, rd7;
ld.global.v2.f32 {f599, f600}, [rd6];
mul.f32 f603, f438, f600;
mul.f32 f605, f599, f438;
mul.f32 f607, f600, f600;
mul.f32 f1610, f599, f599;
sub.f32 f608, f1610, f607;
mul.f32 f609, f600, f599;
fma.rn.f32 f610, f600, f599, f609;
mul.f32 f611, f480, f610;
mul.f32 f613, f608, f480;
mul.f32 f615, f600, f610;
mul.f32 f1609, f599, f608;
sub.f32 f616, f1609, f615;
mul.f32 f1608, f476, f610;
mul.f32 f617, f599, f610;
fma.rn.f32 f618, f600, f608, f617;
mul.f32 f619, f522, f618;
mul.f32 f621, f616, f522;
mul.f32 f1606, f599, f616;
mul.f32 f1607, f600, f618;
sub.f32 f624, f1606, f1607;
mul.f32 f1605, f518, f618;
mul.f32 f625, f599, f618;
fma.rn.f32 f626, f600, f616, f625;
mul.f32 f627, f564, f626;
mul.f32 f629, f624, f564;
mul.f32 f631, f600, f626;
mul.f32 f1604, f599, f624;
sub.f32 f632, f1604, f631;
mul.f32 f1603, f560, f626;
mul.f32 f633, f599, f626;
fma.rn.f32 f634, f600, f624, f633;
mul.f32 f635, f421, f634;
mul.f32 f637, f632, f421;
mul.f32 f1601, f599, f632;
mul.f32 f1602, f600, f634;
sub.f32 f640, f1601, f1602;
mul.f32 f1600, f404, f634;
mul.f32 f641, f599, f634;
fma.rn.f32 f642, f600, f632, f641;
mul.f32 f643, f463, f642;
mul.f32 f645, f640, f463;
mul.f32 f647, f600, f642;
mul.f32 f1599, f599, f640;
sub.f32 f648, f1599, f647;
mul.f32 f1598, f446, f642;
mul.f32 f649, f599, f642;
fma.rn.f32 f650, f600, f640, f649;
mul.f32 f651, f505, f650;
mul.f32 f653, f648, f505;
mul.f32 f655, f600, f650;
mul.f32 f1597, f599, f648;
sub.f32 f656, f1597, f655;
mul.f32 f1596, f488, f650;
mul.f32 f657, f599, f650;
fma.rn.f32 f658, f600, f648, f657;
mul.f32 f659, f547, f658;
mul.f32 f661, f656, f547;
mul.f32 f1594, f599, f656;
mul.f32 f1595, f600, f658;
sub.f32 f664, f1594, f1595;
mul.f32 f1593, f530, f658;
mul.f32 f665, f599, f658;
fma.rn.f32 f666, f600, f656, f665;
mul.f32 f667, f589, f666;
mul.f32 f669, f664, f589;
mul.f32 f671, f600, f666;
mul.f32 f1592, f599, f664;
sub.f32 f672, f1592, f671;
mul.f32 f1591, f572, f666;
mul.f32 f673, f599, f666;
fma.rn.f32 f674, f600, f664, f673;
mul.f32 f675, f429, f674;
mul.f32 f677, f672, f429;
mul.f32 f679, f600, f674;
mul.f32 f1590, f599, f672;
sub.f32 f680, f1590, f679;
mul.f32 f1589, f412, f674;
mul.f32 f681, f599, f674;
fma.rn.f32 f682, f600, f672, f681;
mul.f32 f683, f471, f682;
mul.f32 f685, f680, f471;
mul.f32 f1587, f599, f680;
mul.f32 f1588, f600, f682;
sub.f32 f688, f1587, f1588;
mul.f32 f1586, f454, f682;
mul.f32 f689, f599, f682;
fma.rn.f32 f690, f600, f680, f689;
mul.f32 f691, f513, f690;
mul.f32 f693, f688, f513;
mul.f32 f695, f600, f690;
mul.f32 f1585, f599, f688;
sub.f32 f696, f1585, f695;
mul.f32 f1584, f496, f690;
mul.f32 f697, f599, f690;
fma.rn.f32 f698, f600, f688, f697;
mul.f32 f699, f555, f698;
mul.f32 f701, f696, f555;
mul.f32 f1582, f599, f696;
mul.f32 f1583, f600, f698;
sub.f32 f704, f1582, f1583;
mul.f32 f1581, f538, f698;
mul.f32 f705, f599, f698;
fma.rn.f32 f706, f600, f696, f705;
mul.f32 f707, f597, f706;
mul.f32 f709, f704, f597;
mul.f32 f711, f600, f706;
mul.f32 f1580, f599, f704;
sub.f32 f712, f1580, f711;
mul.f32 f1579, f580, f706;
mul.f32 f713, f599, f706;
fma.rn.f32 f714, f600, f704, f713;
mul.f32 f715, f430, f714;
mul.f32 f717, f712, f430;
mul.f32 f719, f600, f714;
mul.f32 f1578, f599, f712;
sub.f32 f720, f1578, f719;
mul.f32 f1577, f413, f714;
mul.f32 f721, f599, f714;
fma.rn.f32 f722, f600, f712, f721;
mul.f32 f723, f472, f722;
mul.f32 f725, f720, f472;
mul.f32 f1575, f599, f720;
mul.f32 f1576, f600, f722;
sub.f32 f728, f1575, f1576;
mul.f32 f1574, f455, f722;
mul.f32 f729, f599, f722;
fma.rn.f32 f730, f600, f720, f729;
mul.f32 f731, f514, f730;
mul.f32 f733, f728, f514;
mul.f32 f735, f600, f730;
mul.f32 f1573, f599, f728;
sub.f32 f736, f1573, f735;
mul.f32 f1572, f497, f730;
mul.f32 f737, f599, f730;
fma.rn.f32 f738, f600, f728, f737;
mul.f32 f739, f556, f738;
mul.f32 f741, f736, f556;
mul.f32 f743, f600, f738;
mul.f32 f1571, f599, f736;
sub.f32 f744, f1571, f743;
mul.f32 f1570, f539, f738;
mul.f32 f745, f599, f738;
fma.rn.f32 f746, f600, f736, f745;
mul.f32 f747, f598, f746;
mul.f32 f749, f744, f598;
mul.f32 f1568, f599, f744;
mul.f32 f1569, f600, f746;
sub.f32 f752, f1568, f1569;
mul.f32 f1567, f581, f746;
mul.f32 f753, f599, f746;
fma.rn.f32 f754, f600, f744, f753;
mul.f32 f755, f422, f754;
mul.f32 f757, f752, f422;
mul.f32 f759, f600, f754;
mul.f32 f1566, f599, f752;
sub.f32 f760, f1566, f759;
mul.f32 f1565, f405, f754;
mul.f32 f761, f599, f754;
fma.rn.f32 f762, f600, f752, f761;
mul.f32 f763, f464, f762;
mul.f32 f765, f760, f464;
mul.f32 f1563, f599, f760;
mul.f32 f1564, f600, f762;
sub.f32 f768, f1563, f1564;
mul.f32 f1562, f447, f762;
mul.f32 f769, f599, f762;
fma.rn.f32 f770, f600, f760, f769;
mul.f32 f771, f506, f770;
mul.f32 f773, f768, f506;
mul.f32 f775, f600, f770;
mul.f32 f1561, f599, f768;
sub.f32 f776, f1561, f775;
mul.f32 f1560, f489, f770;
mul.f32 f777, f599, f770;
fma.rn.f32 f778, f600, f768, f777;
mul.f32 f779, f548, f778;
mul.f32 f781, f776, f548;
mul.f32 f783, f600, f778;
mul.f32 f1559, f599, f776;
sub.f32 f784, f1559, f783;
mul.f32 f1558, f531, f778;
mul.f32 f785, f599, f778;
mul.f32 f1557, f434, f600;
fma.rn.f32 f786, f600, f776, f785;
mul.f32 f787, f590, f786;
mul.f32 f788, f573, f786;
mul.f32 f789, f784, f590;
barrier.sync 0;
mad.lo.s32 r9, r7, 200, r8;
add.f32 f790, f1643, f1638;
add.f32 f791, f393, f1641;
st.shared.v2.f32 [r9], {f791, f790};
fma.rn.f32 f792, f599, f434, f603;
sub.f32 f793, f605, f1557;
st.shared.v2.f32 [r9+8], {f792, f793};
fma.rn.f32 f794, f608, f476, f611;
sub.f32 f795, f613, f1608;
st.shared.v2.f32 [r9+16], {f794, f795};
fma.rn.f32 f796, f616, f518, f619;
sub.f32 f797, f621, f1605;
st.shared.v2.f32 [r9+24], {f796, f797};
fma.rn.f32 f798, f624, f560, f627;
sub.f32 f799, f629, f1603;
st.shared.v2.f32 [r9+32], {f798, f799};
sub.f32 f800, f637, f1600;
fma.rn.f32 f801, f632, f404, f635;
st.shared.v2.f32 [r9+40], {f801, f800};
fma.rn.f32 f802, f640, f446, f643;
sub.f32 f803, f645, f1598;
st.shared.v2.f32 [r9+48], {f802, f803};
sub.f32 f804, f653, f1596;
fma.rn.f32 f805, f648, f488, f651;
st.shared.v2.f32 [r9+56], {f805, f804};
fma.rn.f32 f806, f656, f530, f659;
sub.f32 f807, f661, f1593;
st.shared.v2.f32 [r9+64], {f806, f807};
fma.rn.f32 f808, f664, f572, f667;
sub.f32 f809, f669, f1591;
st.shared.v2.f32 [r9+72], {f808, f809};
fma.rn.f32 f810, f672, f412, f675;
sub.f32 f811, f677, f1589;
st.shared.v2.f32 [r9+80], {f810, f811};
fma.rn.f32 f812, f680, f454, f683;
sub.f32 f813, f685, f1586;
st.shared.v2.f32 [r9+88], {f812, f813};
fma.rn.f32 f814, f688, f496, f691;
sub.f32 f815, f693, f1584;
st.shared.v2.f32 [r9+96], {f814, f815};
fma.rn.f32 f816, f696, f538, f699;
sub.f32 f817, f701, f1581;
st.shared.v2.f32 [r9+104], {f816, f817};
fma.rn.f32 f818, f704, f580, f707;
sub.f32 f819, f709, f1579;
st.shared.v2.f32 [r9+112], {f818, f819};
fma.rn.f32 f820, f712, f413, f715;
sub.f32 f821, f717, f1577;
st.shared.v2.f32 [r9+120], {f820, f821};
fma.rn.f32 f822, f720, f455, f723;
sub.f32 f823, f725, f1574;
st.shared.v2.f32 [r9+128], {f822, f823};
fma.rn.f32 f824, f728, f497, f731;
sub.f32 f825, f733, f1572;
st.shared.v2.f32 [r9+136], {f824, f825};
fma.rn.f32 f826, f736, f539, f739;
sub.f32 f827, f741, f1570;
st.shared.v2.f32 [r9+144], {f826, f827};
fma.rn.f32 f828, f744, f581, f747;
sub.f32 f829, f749, f1567;
st.shared.v2.f32 [r9+152], {f828, f829};
fma.rn.f32 f830, f752, f405, f755;
sub.f32 f831, f757, f1565;
st.shared.v2.f32 [r9+160], {f830, f831};
fma.rn.f32 f832, f760, f447, f763;
sub.f32 f833, f765, f1562;
st.shared.v2.f32 [r9+168], {f832, f833};
fma.rn.f32 f834, f768, f489, f771;
sub.f32 f835, f773, f1560;
st.shared.v2.f32 [r9+176], {f834, f835};
fma.rn.f32 f836, f776, f531, f779;
sub.f32 f837, f781, f1558;
st.shared.v2.f32 [r9+184], {f836, f837};
fma.rn.f32 f838, f784, f573, f787;
sub.f32 f839, f789, f788;
st.shared.v2.f32 [r9+192], {f838, f839};
barrier.sync 0;
mad.lo.s32 r10, r7, -192, r9;
ld.shared.v2.f32 {f840, f841}, [r10];
ld.shared.v2.f32 {f844, f845}, [r10+200];
ld.shared.v2.f32 {f848, f849}, [r10+400];
ld.shared.v2.f32 {f852, f853}, [r10+600];
ld.shared.v2.f32 {f856, f857}, [r10+800];
ld.shared.v2.f32 {f860, f861}, [r10+1000];
ld.shared.v2.f32 {f864, f865}, [r10+1200];
ld.shared.v2.f32 {f868, f869}, [r10+1400];
ld.shared.v2.f32 {f872, f873}, [r10+1600];
ld.shared.v2.f32 {f876, f877}, [r10+1800];
ld.shared.v2.f32 {f880, f881}, [r10+2000];
ld.shared.v2.f32 {f884, f885}, [r10+2200];
ld.shared.v2.f32 {f888, f889}, [r10+2400];
ld.shared.v2.f32 {f892, f893}, [r10+2600];
ld.shared.v2.f32 {f896, f897}, [r10+2800];
ld.shared.v2.f32 {f900, f901}, [r10+3000];
ld.shared.v2.f32 {f904, f905}, [r10+3200];
ld.shared.v2.f32 {f908, f909}, [r10+3400];
ld.shared.v2.f32 {f912, f913}, [r10+3600];
ld.shared.v2.f32 {f916, f917}, [r10+3800];
ld.shared.v2.f32 {f920, f921}, [r10+4000];
ld.shared.v2.f32 {f924, f925}, [r10+4200];
ld.shared.v2.f32 {f928, f929}, [r10+4400];
ld.shared.v2.f32 {f932, f933}, [r10+4600];
ld.shared.v2.f32 {f936, f937}, [r10+4800];
add.f32 f940, f860, f920;
add.f32 f942, f880, f900;
add.f32 f1556, f840, f940;
add.f32 f943, f942, f1556;
add.f32 f944, f861, f921;
add.f32 f946, f881, f901;
add.f32 f1555, f841, f944;
add.f32 f947, f946, f1555;
mul.f32 f949, f942, 0f3F4F1BBD;
fma.rn.f32 f1554, f940, 0f3E9E377A, f840;
sub.f32 f950, f1554, f949;
sub.f32 f951, f861, f921;
sub.f32 f953, f881, f901;
mul.f32 f1553, f951, 0f3F737871;
fma.rn.f32 f954, f953, 0f3F167918, f1553;
sub.f32 f955, f950, f954;
add.f32 f956, f954, f950;
mul.f32 f957, f940, 0f3F4F1BBD;
sub.f32 f958, f840, f957;
fma.rn.f32 f959, f942, 0f3E9E377A, f958;
mul.f32 f960, f951, 0f3F167918;
mul.f32 f961, f953, 0f3F737871;
sub.f32 f962, f960, f961;
sub.f32 f963, f959, f962;
add.f32 f964, f962, f959;
mul.f32 f966, f946, 0f3F4F1BBD;
fma.rn.f32 f1552, f944, 0f3E9E377A, f841;
sub.f32 f967, f1552, f966;
sub.f32 f968, f860, f920;
sub.f32 f970, f880, f900;
mul.f32 f1551, f968, 0f3F737871;
fma.rn.f32 f971, f970, 0f3F167918, f1551;
add.f32 f972, f971, f967;
sub.f32 f973, f967, f971;
mul.f32 f974, f944, 0f3F4F1BBD;
sub.f32 f975, f841, f974;
fma.rn.f32 f976, f946, 0f3E9E377A, f975;
mul.f32 f977, f968, 0f3F167918;
mul.f32 f978, f970, 0f3F737871;
sub.f32 f979, f977, f978;
add.f32 f980, f979, f976;
sub.f32 f981, f976, f979;
add.f32 f982, f864, f924;
add.f32 f984, f884, f904;
add.f32 f1550, f844, f982;
add.f32 f985, f984, f1550;
add.f32 f986, f865, f925;
add.f32 f988, f885, f905;
add.f32 f1549, f845, f986;
add.f32 f989, f988, f1549;
fma.rn.f32 f1547, f982, 0f3E9E377A, f844;
mul.f32 f1548, f984, 0f3F4F1BBD;
sub.f32 f992, f1547, f1548;
sub.f32 f993, f865, f925;
sub.f32 f995, f885, f905;
mul.f32 f1546, f993, 0f3F737871;
fma.rn.f32 f996, f995, 0f3F167918, f1546;
sub.f32 f997, f992, f996;
add.f32 f998, f996, f992;
mul.f32 f999, f982, 0f3F4F1BBD;
sub.f32 f1000, f844, f999;
fma.rn.f32 f1001, f984, 0f3E9E377A, f1000;
mul.f32 f1002, f993, 0f3F167918;
mul.f32 f1003, f995, 0f3F737871;
sub.f32 f1004, f1002, f1003;
sub.f32 f1005, f1001, f1004;
add.f32 f1006, f1004, f1001;
mul.f32 f1008, f988, 0f3F4F1BBD;
fma.rn.f32 f1545, f986, 0f3E9E377A, f845;
sub.f32 f1009, f1545, f1008;
sub.f32 f1010, f864, f924;
sub.f32 f1012, f884, f904;
mul.f32 f1544, f1010, 0f3F737871;
fma.rn.f32 f1013, f1012, 0f3F167918, f1544;
add.f32 f1014, f1013, f1009;
sub.f32 f1015, f1009, f1013;
mul.f32 f1016, f986, 0f3F4F1BBD;
sub.f32 f1017, f845, f1016;
fma.rn.f32 f1018, f988, 0f3E9E377A, f1017;
mul.f32 f1019, f1010, 0f3F167918;
mul.f32 f1020, f1012, 0f3F737871;
sub.f32 f1021, f1019, f1020;
add.f32 f1022, f1021, f1018;
sub.f32 f1023, f1018, f1021;
add.f32 f1024, f868, f928;
add.f32 f1026, f888, f908;
add.f32 f1543, f848, f1024;
add.f32 f1027, f1026, f1543;
add.f32 f1028, f869, f929;
add.f32 f1030, f889, f909;
add.f32 f1542, f849, f1028;
add.f32 f1031, f1030, f1542;
fma.rn.f32 f1540, f1024, 0f3E9E377A, f848;
mul.f32 f1541, f1026, 0f3F4F1BBD;
sub.f32 f1034, f1540, f1541;
sub.f32 f1035, f869, f929;
sub.f32 f1037, f889, f909;
mul.f32 f1539, f1035, 0f3F737871;
fma.rn.f32 f1038, f1037, 0f3F167918, f1539;
sub.f32 f1039, f1034, f1038;
add.f32 f1040, f1038, f1034;
mul.f32 f1041, f1024, 0f3F4F1BBD;
sub.f32 f1042, f848, f1041;
fma.rn.f32 f1043, f1026, 0f3E9E377A, f1042;
mul.f32 f1044, f1035, 0f3F167918;
mul.f32 f1045, f1037, 0f3F737871;
sub.f32 f1046, f1044, f1045;
sub.f32 f1047, f1043, f1046;
add.f32 f1048, f1046, f1043;
fma.rn.f32 f1537, f1028, 0f3E9E377A, f849;
mul.f32 f1538, f1030, 0f3F4F1BBD;
sub.f32 f1051, f1537, f1538;
sub.f32 f1052, f868, f928;
sub.f32 f1054, f888, f908;
mul.f32 f1536, f1052, 0f3F737871;
fma.rn.f32 f1055, f1054, 0f3F167918, f1536;
add.f32 f1056, f1055, f1051;
sub.f32 f1057, f1051, f1055;
mul.f32 f1058, f1028, 0f3F4F1BBD;
sub.f32 f1059, f849, f1058;
fma.rn.f32 f1060, f1030, 0f3E9E377A, f1059;
mul.f32 f1061, f1052, 0f3F167918;
mul.f32 f1062, f1054, 0f3F737871;
sub.f32 f1063, f1061, f1062;
add.f32 f1064, f1063, f1060;
sub.f32 f1065, f1060, f1063;
add.f32 f1066, f872, f932;
add.f32 f1068, f892, f912;
add.f32 f1535, f852, f1066;
add.f32 f1069, f1068, f1535;
add.f32 f1070, f873, f933;
add.f32 f1072, f893, f913;
add.f32 f1534, f853, f1070;
add.f32 f1073, f1072, f1534;
mul.f32 f1075, f1068, 0f3F4F1BBD;
fma.rn.f32 f1533, f1066, 0f3E9E377A, f852;
sub.f32 f1076, f1533, f1075;
sub.f32 f1077, f873, f933;
sub.f32 f1079, f893, f913;
mul.f32 f1532, f1077, 0f3F737871;
fma.rn.f32 f1080, f1079, 0f3F167918, f1532;
sub.f32 f1081, f1076, f1080;
add.f32 f1082, f1080, f1076;
mul.f32 f1083, f1066, 0f3F4F1BBD;
sub.f32 f1084, f852, f1083;
fma.rn.f32 f1085, f1068, 0f3E9E377A, f1084;
mul.f32 f1086, f1077, 0f3F167918;
mul.f32 f1087, f1079, 0f3F737871;
sub.f32 f1088, f1086, f1087;
sub.f32 f1089, f1085, f1088;
add.f32 f1090, f1088, f1085;
fma.rn.f32 f1530, f1070, 0f3E9E377A, f853;
mul.f32 f1531, f1072, 0f3F4F1BBD;
sub.f32 f1093, f1530, f1531;
sub.f32 f1094, f872, f932;
sub.f32 f1096, f892, f912;
mul.f32 f1529, f1094, 0f3F737871;
fma.rn.f32 f1097, f1096, 0f3F167918, f1529;
add.f32 f1098, f1097, f1093;
sub.f32 f1099, f1093, f1097;
mul.f32 f1100, f1070, 0f3F4F1BBD;
sub.f32 f1101, f853, f1100;
fma.rn.f32 f1102, f1072, 0f3E9E377A, f1101;
mul.f32 f1103, f1094, 0f3F167918;
mul.f32 f1104, f1096, 0f3F737871;
sub.f32 f1105, f1103, f1104;
add.f32 f1106, f1105, f1102;
sub.f32 f1107, f1102, f1105;
add.f32 f1108, f876, f936;
add.f32 f1110, f896, f916;
add.f32 f1528, f856, f1108;
add.f32 f1111, f1110, f1528;
add.f32 f1112, f877, f937;
add.f32 f1114, f897, f917;
add.f32 f1527, f857, f1112;
add.f32 f1115, f1114, f1527;
mul.f32 f1117, f1110, 0f3F4F1BBD;
fma.rn.f32 f1526, f1108, 0f3E9E377A, f856;
sub.f32 f1118, f1526, f1117;
sub.f32 f1119, f877, f937;
sub.f32 f1121, f897, f917;
mul.f32 f1525, f1119, 0f3F737871;
fma.rn.f32 f1122, f1121, 0f3F167918, f1525;
sub.f32 f1123, f1118, f1122;
add.f32 f1124, f1122, f1118;
mul.f32 f1125, f1108, 0f3F4F1BBD;
sub.f32 f1126, f856, f1125;
fma.rn.f32 f1127, f1110, 0f3E9E377A, f1126;
mul.f32 f1128, f1119, 0f3F167918;
mul.f32 f1129, f1121, 0f3F737871;
sub.f32 f1130, f1128, f1129;
sub.f32 f1131, f1127, f1130;
add.f32 f1132, f1130, f1127;
mul.f32 f1134, f1114, 0f3F4F1BBD;
fma.rn.f32 f1524, f1112, 0f3E9E377A, f857;
sub.f32 f1135, f1524, f1134;
sub.f32 f1136, f876, f936;
sub.f32 f1138, f896, f916;
mul.f32 f1523, f1136, 0f3F737871;
fma.rn.f32 f1139, f1138, 0f3F167918, f1523;
add.f32 f1140, f1139, f1135;
sub.f32 f1141, f1135, f1139;
mul.f32 f1142, f1112, 0f3F4F1BBD;
sub.f32 f1143, f857, f1142;
fma.rn.f32 f1144, f1114, 0f3E9E377A, f1143;
mul.f32 f1145, f1136, 0f3F167918;
mul.f32 f1146, f1138, 0f3F737871;
sub.f32 f1147, f1145, f1146;
add.f32 f1148, f1147, f1144;
sub.f32 f1149, f1144, f1147;
mul.f32 f1151, f1014, 0f3E7EA890;
mul.f32 f1522, f997, 0f3F77F511;
sub.f32 f1152, f1522, f1151;
mul.f32 f1153, f1014, 0f3F77F511;
fma.rn.f32 f1154, f997, 0f3E7EA890, f1153;
mul.f32 f1520, f1039, 0f3F6055A2;
mul.f32 f1521, f1056, 0f3EF6A86B;
sub.f32 f1157, f1520, f1521;
mul.f32 f1158, f1056, 0f3F6055A2;
fma.rn.f32 f1159, f1039, 0f3EF6A86B, f1158;
mul.f32 f1518, f1081, 0f3F3A9DB0;
mul.f32 f1519, f1098, 0f3F2F3E7B;
sub.f32 f1162, f1518, f1519;
mul.f32 f1163, f1098, 0f3F3A9DB0;
fma.rn.f32 f1164, f1081, 0f3F2F3E7B, f1163;
mul.f32 f1516, f1123, 0f3F092BF2;
mul.f32 f1517, f1140, 0f3F5825E0;
sub.f32 f1167, f1516, f1517;
mul.f32 f1168, f1140, 0f3F092BF2;
fma.rn.f32 f1169, f1123, 0f3F5825E0, f1168;
mul.f32 f1514, f1005, 0f3F6055A2;
mul.f32 f1515, f1022, 0f3EF6A86B;
sub.f32 f1172, f1514, f1515;
mul.f32 f1173, f1022, 0f3F6055A2;
fma.rn.f32 f1174, f1005, 0f3EF6A86B, f1173;
mul.f32 f1176, f1064, 0f3F5825E0;
mul.f32 f1513, f1047, 0f3F092BF2;
sub.f32 f1177, f1513, f1176;
mul.f32 f1178, f1064, 0f3F092BF2;
fma.rn.f32 f1179, f1047, 0f3F5825E0, f1178;
mul.f32 f1181, f1106, 0f3F7F7EAE;
mul.f32 f1512, f1089, 0f3D809851;
sub.f32 f1182, f1512, f1181;
mul.f32 f1183, f1106, 0f3D809851;
fma.rn.f32 f1184, f1089, 0f3F7F7EAE, f1183;
mul.f32 f1186, f1148, 0f3F67A2BF;
mul.f32 f1511, f1131, 0fBED9FFBE;
sub.f32 f1187, f1511, f1186;
mul.f32 f1188, f1148, 0fBED9FFBE;
fma.rn.f32 f1189, f1131, 0f3F67A2BF, f1188;
mul.f32 f1191, f1023, 0f3F2F3E7B;
mul.f32 f1510, f1006, 0f3F3A9DB0;
sub.f32 f1192, f1510, f1191;
mul.f32 f1193, f1023, 0f3F3A9DB0;
fma.rn.f32 f1194, f1006, 0f3F2F3E7B, f1193;
mul.f32 f1196, f1065, 0f3F7F7EAE;
mul.f32 f1509, f1048, 0f3D809851;
sub.f32 f1197, f1509, f1196;
mul.f32 f1198, f1065, 0f3D809851;
fma.rn.f32 f1199, f1048, 0f3F7F7EAE, f1198;
mul.f32 f1201, f1107, 0f3F45405B;
mul.f32 f1508, f1090, 0fBF232E38;
sub.f32 f1202, f1508, f1201;
mul.f32 f1203, f1107, 0fBF232E38;
fma.rn.f32 f1204, f1090, 0f3F45405B, f1203;
mul.f32 f1506, f1132, 0fBF7DFB3B;
mul.f32 f1507, f1149, 0f3E00575B;
sub.f32 f1207, f1506, f1507;
mul.f32 f1208, f1149, 0fBF7DFB3B;
fma.rn.f32 f1209, f1132, 0f3E00575B, f1208;
mul.f32 f1504, f998, 0f3F092BF2;
mul.f32 f1505, f1015, 0f3F5825E0;
sub.f32 f1212, f1504, f1505;
mul.f32 f1213, f1015, 0f3F092BF2;
fma.rn.f32 f1214, f998, 0f3F5825E0, f1213;
mul.f32 f1502, f1040, 0fBED9FFBE;
mul.f32 f1503, f1057, 0f3F67A2BF;
sub.f32 f1217, f1502, f1503;
mul.f32 f1218, f1057, 0fBED9FFBE;
fma.rn.f32 f1219, f1040, 0f3F67A2BF, f1218;
mul.f32 f1221, f1099, 0f3E00575B;
mul.f32 f1501, f1082, 0fBF7DFB3B;
sub.f32 f1222, f1501, f1221;
mul.f32 f1223, f1099, 0fBF7DFB3B;
fma.rn.f32 f1224, f1082, 0f3E00575B, f1223;
mul.f32 f1226, f1141, 0fBF45405B;
mul.f32 f1500, f1124, 0fBF232E38;
sub.f32 f1227, f1500, f1226;
mul.f32 f1228, f1141, 0fBF232E38;
fma.rn.f32 f1229, f1124, 0fBF45405B, f1228;
add.f32 f1230, f985, f1111;
add.f32 f1232, f1027, f1069;
fma.rn.f32 f1498, f1230, 0f3E9E377A, f943;
mul.f32 f1499, f1232, 0f3F4F1BBD;
sub.f32 f1238, f1498, f1499;
add.f32 f1497, f989, f1115;
sub.f32 f1239, f989, f1115;
add.f32 f1496, f1031, f1073;
sub.f32 f1241, f1031, f1073;
mul.f32 f1495, f1239, 0f3F737871;
fma.rn.f32 f1242, f1241, 0f3F167918, f1495;
add.f32 f1494, f943, f1230;
mul.f32 f1243, f1230, 0f3F4F1BBD;
sub.f32 f1244, f943, f1243;
fma.rn.f32 f1245, f1232, 0f3E9E377A, f1244;
mul.f32 f1246, f1239, 0f3F167918;
mul.f32 f1247, f1241, 0f3F737871;
sub.f32 f1248, f1246, f1247;
mul.f32 f1250, f1496, 0f3F4F1BBD;
fma.rn.f32 f1493, f1497, 0f3E9E377A, f947;
sub.f32 f1251, f1493, f1250;
sub.f32 f1252, f985, f1111;
sub.f32 f1254, f1027, f1069;
mul.f32 f1492, f1252, 0f3F737871;
fma.rn.f32 f1255, f1254, 0f3F167918, f1492;
add.f32 f1491, f947, f1497;
mul.f32 f1256, f1497, 0f3F4F1BBD;
sub.f32 f1257, f947, f1256;
fma.rn.f32 f1258, f1496, 0f3E9E377A, f1257;
mul.f32 f1259, f1252, 0f3F167918;
mul.f32 f1260, f1254, 0f3F737871;
sub.f32 f1261, f1259, f1260;
add.f32 f1262, f1152, f1167;
add.f32 f1264, f1157, f1162;
mul.f32 f1269, f1264, 0f3F4F1BBD;
fma.rn.f32 f1490, f1262, 0f3E9E377A, f955;
sub.f32 f1270, f1490, f1269;
add.f32 f1489, f1154, f1169;
sub.f32 f1271, f1154, f1169;
add.f32 f1488, f1159, f1164;
sub.f32 f1273, f1159, f1164;
mul.f32 f1487, f1271, 0f3F737871;
fma.rn.f32 f1274, f1273, 0f3F167918, f1487;
add.f32 f1486, f955, f1262;
mul.f32 f1275, f1262, 0f3F4F1BBD;
sub.f32 f1276, f955, f1275;
fma.rn.f32 f1277, f1264, 0f3E9E377A, f1276;
mul.f32 f1278, f1271, 0f3F167918;
mul.f32 f1279, f1273, 0f3F737871;
sub.f32 f1280, f1278, f1279;
fma.rn.f32 f1484, f1489, 0f3E9E377A, f972;
mul.f32 f1485, f1488, 0f3F4F1BBD;
sub.f32 f1283, f1484, f1485;
sub.f32 f1284, f1152, f1167;
sub.f32 f1286, f1157, f1162;
mul.f32 f1483, f1284, 0f3F737871;
fma.rn.f32 f1287, f1286, 0f3F167918, f1483;
add.f32 f1482, f972, f1489;
mul.f32 f1288, f1489, 0f3F4F1BBD;
sub.f32 f1289, f972, f1288;
fma.rn.f32 f1290, f1488, 0f3E9E377A, f1289;
mul.f32 f1291, f1284, 0f3F167918;
mul.f32 f1292, f1286, 0f3F737871;
sub.f32 f1293, f1291, f1292;
add.f32 f1294, f1172, f1187;
add.f32 f1296, f1177, f1182;
fma.rn.f32 f1480, f1294, 0f3E9E377A, f963;
mul.f32 f1481, f1296, 0f3F4F1BBD;
sub.f32 f1302, f1480, f1481;
add.f32 f1479, f1174, f1189;
sub.f32 f1303, f1174, f1189;
add.f32 f1478, f1179, f1184;
sub.f32 f1305, f1179, f1184;
mul.f32 f1477, f1303, 0f3F737871;
fma.rn.f32 f1306, f1305, 0f3F167918, f1477;
add.f32 f1476, f963, f1294;
mul.f32 f1307, f1294, 0f3F4F1BBD;
sub.f32 f1308, f963, f1307;
fma.rn.f32 f1309, f1296, 0f3E9E377A, f1308;
mul.f32 f1310, f1303, 0f3F167918;
mul.f32 f1311, f1305, 0f3F737871;
sub.f32 f1312, f1310, f1311;
mul.f32 f1314, f1478, 0f3F4F1BBD;
fma.rn.f32 f1475, f1479, 0f3E9E377A, f980;
sub.f32 f1315, f1475, f1314;
sub.f32 f1316, f1172, f1187;
sub.f32 f1318, f1177, f1182;
mul.f32 f1474, f1316, 0f3F737871;
fma.rn.f32 f1319, f1318, 0f3F167918, f1474;
add.f32 f1473, f980, f1479;
mul.f32 f1320, f1479, 0f3F4F1BBD;
sub.f32 f1321, f980, f1320;
fma.rn.f32 f1322, f1478, 0f3E9E377A, f1321;
mul.f32 f1323, f1316, 0f3F167918;
mul.f32 f1324, f1318, 0f3F737871;
sub.f32 f1325, f1323, f1324;
add.f32 f1326, f1192, f1207;
add.f32 f1328, f1197, f1202;
mul.f32 f1333, f1328, 0f3F4F1BBD;
fma.rn.f32 f1472, f1326, 0f3E9E377A, f964;
sub.f32 f1334, f1472, f1333;
add.f32 f1471, f1194, f1209;
sub.f32 f1335, f1194, f1209;
add.f32 f1470, f1199, f1204;
sub.f32 f1337, f1199, f1204;
mul.f32 f1469, f1335, 0f3F737871;
fma.rn.f32 f1338, f1337, 0f3F167918, f1469;
add.f32 f1468, f964, f1326;
mul.f32 f1339, f1326, 0f3F4F1BBD;
sub.f32 f1340, f964, f1339;
fma.rn.f32 f1341, f1328, 0f3E9E377A, f1340;
mul.f32 f1342, f1335, 0f3F167918;
mul.f32 f1343, f1337, 0f3F737871;
sub.f32 f1344, f1342, f1343;
fma.rn.f32 f1466, f1471, 0f3E9E377A, f981;
mul.f32 f1467, f1470, 0f3F4F1BBD;
sub.f32 f1347, f1466, f1467;
sub.f32 f1348, f1192, f1207;
sub.f32 f1350, f1197, f1202;
mul.f32 f1465, f1348, 0f3F737871;
fma.rn.f32 f1351, f1350, 0f3F167918, f1465;
add.f32 f1464, f981, f1471;
mul.f32 f1352, f1471, 0f3F4F1BBD;
sub.f32 f1353, f981, f1352;
fma.rn.f32 f1354, f1470, 0f3E9E377A, f1353;
mul.f32 f1355, f1348, 0f3F167918;
mul.f32 f1356, f1350, 0f3F737871;
sub.f32 f1357, f1355, f1356;
add.f32 f1358, f1212, f1227;
add.f32 f1360, f1217, f1222;
fma.rn.f32 f1462, f1358, 0f3E9E377A, f956;
mul.f32 f1463, f1360, 0f3F4F1BBD;
sub.f32 f1366, f1462, f1463;
add.f32 f1461, f1214, f1229;
sub.f32 f1367, f1214, f1229;
add.f32 f1460, f1219, f1224;
sub.f32 f1369, f1219, f1224;
mul.f32 f1459, f1367, 0f3F737871;
fma.rn.f32 f1370, f1369, 0f3F167918, f1459;
add.f32 f1458, f956, f1358;
mul.f32 f1371, f1358, 0f3F4F1BBD;
sub.f32 f1372, f956, f1371;
fma.rn.f32 f1373, f1360, 0f3E9E377A, f1372;
mul.f32 f1374, f1367, 0f3F167918;
mul.f32 f1375, f1369, 0f3F737871;
sub.f32 f1376, f1374, f1375;
mul.f32 f1378, f1460, 0f3F4F1BBD;
fma.rn.f32 f1457, f1461, 0f3E9E377A, f973;
sub.f32 f1379, f1457, f1378;
sub.f32 f1380, f1212, f1227;
sub.f32 f1382, f1217, f1222;
mul.f32 f1456, f1380, 0f3F737871;
fma.rn.f32 f1383, f1382, 0f3F167918, f1456;
add.f32 f1455, f973, f1461;
mul.f32 f1384, f1461, 0f3F4F1BBD;
sub.f32 f1385, f973, f1384;
fma.rn.f32 f1386, f1460, 0f3E9E377A, f1385;
mul.f32 f1387, f1380, 0f3F167918;
mul.f32 f1388, f1382, 0f3F737871;
sub.f32 f1389, f1387, f1388;
add.f32 %1, f1496, f1491;
add.f32 %0, f1232, f1494;
add.f32 %3, f1488, f1482;
add.f32 %2, f1264, f1486;
add.f32 %5, f1478, f1473;
add.f32 %4, f1296, f1476;
add.f32 %7, f1470, f1464;
add.f32 %6, f1328, f1468;
add.f32 %9, f1460, f1455;
add.f32 %8, f1360, f1458;
add.f32 %11, f1255, f1251;
sub.f32 %10, f1238, f1242;
add.f32 %13, f1287, f1283;
sub.f32 %12, f1270, f1274;
add.f32 %15, f1319, f1315;
sub.f32 %14, f1302, f1306;
sub.f32 %16, f1334, f1338;
add.f32 %17, f1351, f1347;
sub.f32 %18, f1366, f1370;
add.f32 %19, f1383, f1379;
sub.f32 %20, f1245, f1248;
add.f32 %21, f1261, f1258;
sub.f32 %22, f1277, f1280;
add.f32 %23, f1293, f1290;
add.f32 %25, f1325, f1322;
sub.f32 %24, f1309, f1312;
add.f32 %27, f1357, f1354;
sub.f32 %26, f1341, f1344;
sub.f32 %28, f1373, f1376;
add.f32 %29, f1389, f1386;
sub.f32 %31, f1258, f1261;
add.f32 %30, f1248, f1245;
sub.f32 %33, f1290, f1293;
add.f32 %32, f1280, f1277;
sub.f32 %35, f1322, f1325;
add.f32 %34, f1312, f1309;
sub.f32 %37, f1354, f1357;
add.f32 %36, f1344, f1341;
sub.f32 %39, f1386, f1389;
add.f32 %38, f1376, f1373;
sub.f32 %41, f1251, f1255;
add.f32 %40, f1242, f1238;
sub.f32 %43, f1283, f1287;
add.f32 %42, f1274, f1270;
sub.f32 %45, f1315, f1319;
add.f32 %44, f1306, f1302;
sub.f32 %47, f1347, f1351;
add.f32 %46, f1338, f1334;
sub.f32 %49, f1379, f1383;
add.f32 %48, f1370, f1366;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_625), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y), "f"(rmem[5].y), "f"(rmem[10].y), "f"(rmem[20].y), "f"(rmem[16].y), "f"(rmem[1].y), "f"(rmem[11].y), "f"(rmem[2].y), "f"(rmem[22].y), "f"(rmem[7].y), "f"(rmem[17].y), "f"(rmem[23].y), "f"(rmem[8].y), "f"(rmem[13].y), "f"(rmem[19].y), "f"(rmem[4].y), "f"(rmem[14].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<364, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<1390>;
.reg .b32 r<11>;
.reg .b64 rd<7>;
mov.u32 r1, %tid.y;
mov.u32 r2, %50;
mad.lo.s32 r3, r1, 2500, r2;
add.f32 f101, %65, %105;
add.f32 f102, %52, f101;
add.f32 f103, %78, %92;
add.f32 f104, f103, f102;
add.f32 f105, %67, %107;
add.f32 f106, %53, f105;
add.f32 f107, %80, %93;
add.f32 f108, f107, f106;
fma.rn.f32 f109, f101, 0f3E9E377A, %52;
mul.f32 f110, f103, 0f3F4F1BBD;
sub.f32 f111, f109, f110;
sub.f32 f112, %67, %107;
mul.f32 f113, f112, 0f3F737871;
sub.f32 f114, %80, %93;
fma.rn.f32 f115, f114, 0f3F167918, f113;
sub.f32 f116, f111, f115;
add.f32 f117, f115, f111;
mul.f32 f118, f101, 0f3F4F1BBD;
sub.f32 f119, %52, f118;
fma.rn.f32 f120, f103, 0f3E9E377A, f119;
mul.f32 f121, f112, 0f3F167918;
mul.f32 f122, f114, 0f3F737871;
sub.f32 f123, f121, f122;
sub.f32 f124, f120, f123;
add.f32 f125, f123, f120;
fma.rn.f32 f126, f105, 0f3E9E377A, %53;
mul.f32 f127, f107, 0f3F4F1BBD;
sub.f32 f128, f126, f127;
sub.f32 f129, %65, %105;
mul.f32 f130, f129, 0f3F737871;
sub.f32 f131, %78, %92;
fma.rn.f32 f132, f131, 0f3F167918, f130;
add.f32 f133, f132, f128;
sub.f32 f134, f128, f132;
mul.f32 f135, f105, 0f3F4F1BBD;
sub.f32 f136, %53, f135;
fma.rn.f32 f137, f107, 0f3E9E377A, f136;
mul.f32 f138, f129, 0f3F167918;
mul.f32 f139, f131, 0f3F737871;
sub.f32 f140, f138, f139;
add.f32 f141, f140, f137;
sub.f32 f142, f137, f140;
add.f32 f143, %68, %108;
add.f32 f144, %54, f143;
add.f32 f145, %81, %94;
add.f32 f146, f145, f144;
add.f32 f147, %69, %109;
add.f32 f148, %56, f147;
add.f32 f149, %83, %96;
add.f32 f150, f149, f148;
fma.rn.f32 f151, f143, 0f3E9E377A, %54;
mul.f32 f152, f145, 0f3F4F1BBD;
sub.f32 f153, f151, f152;
sub.f32 f154, %69, %109;
mul.f32 f155, f154, 0f3F737871;
sub.f32 f156, %83, %96;
fma.rn.f32 f157, f156, 0f3F167918, f155;
sub.f32 f158, f153, f157;
add.f32 f159, f157, f153;
mul.f32 f160, f143, 0f3F4F1BBD;
sub.f32 f161, %54, f160;
fma.rn.f32 f162, f145, 0f3E9E377A, f161;
mul.f32 f163, f154, 0f3F167918;
mul.f32 f164, f156, 0f3F737871;
sub.f32 f165, f163, f164;
sub.f32 f166, f162, f165;
add.f32 f167, f165, f162;
fma.rn.f32 f168, f147, 0f3E9E377A, %56;
mul.f32 f169, f149, 0f3F4F1BBD;
sub.f32 f170, f168, f169;
sub.f32 f171, %68, %108;
mul.f32 f172, f171, 0f3F737871;
sub.f32 f173, %81, %94;
fma.rn.f32 f174, f173, 0f3F167918, f172;
add.f32 f175, f174, f170;
sub.f32 f176, f170, f174;
mul.f32 f177, f147, 0f3F4F1BBD;
sub.f32 f178, %56, f177;
fma.rn.f32 f179, f149, 0f3E9E377A, f178;
mul.f32 f180, f171, 0f3F167918;
mul.f32 f181, f173, 0f3F737871;
sub.f32 f182, f180, f181;
add.f32 f183, f182, f179;
sub.f32 f184, f179, f182;
add.f32 f185, %70, %110;
add.f32 f186, %57, f185;
add.f32 f187, %84, %97;
add.f32 f188, f187, f186;
add.f32 f189, %72, %112;
add.f32 f190, %59, f189;
add.f32 f191, %85, %99;
add.f32 f192, f191, f190;
fma.rn.f32 f193, f185, 0f3E9E377A, %57;
mul.f32 f194, f187, 0f3F4F1BBD;
sub.f32 f195, f193, f194;
sub.f32 f196, %72, %112;
mul.f32 f197, f196, 0f3F737871;
sub.f32 f198, %85, %99;
fma.rn.f32 f199, f198, 0f3F167918, f197;
sub.f32 f200, f195, f199;
add.f32 f201, f199, f195;
mul.f32 f202, f185, 0f3F4F1BBD;
sub.f32 f203, %57, f202;
fma.rn.f32 f204, f187, 0f3E9E377A, f203;
mul.f32 f205, f196, 0f3F167918;
mul.f32 f206, f198, 0f3F737871;
sub.f32 f207, f205, f206;
sub.f32 f208, f204, f207;
add.f32 f209, f207, f204;
fma.rn.f32 f210, f189, 0f3E9E377A, %59;
mul.f32 f211, f191, 0f3F4F1BBD;
sub.f32 f212, f210, f211;
sub.f32 f213, %70, %110;
mul.f32 f214, f213, 0f3F737871;
sub.f32 f215, %84, %97;
fma.rn.f32 f216, f215, 0f3F167918, f214;
add.f32 f217, f216, f212;
sub.f32 f218, f212, f216;
mul.f32 f219, f189, 0f3F4F1BBD;
sub.f32 f220, %59, f219;
fma.rn.f32 f221, f191, 0f3E9E377A, f220;
mul.f32 f222, f213, 0f3F167918;
mul.f32 f223, f215, 0f3F737871;
sub.f32 f224, f222, f223;
add.f32 f225, f224, f221;
sub.f32 f226, f221, f224;
add.f32 f227, %73, %113;
add.f32 f228, %60, f227;
add.f32 f229, %86, %100;
add.f32 f230, f229, f228;
add.f32 f231, %75, %115;
add.f32 f232, %61, f231;
add.f32 f233, %88, %101;
add.f32 f234, f233, f232;
fma.rn.f32 f235, f227, 0f3E9E377A, %60;
mul.f32 f236, f229, 0f3F4F1BBD;
sub.f32 f237, f235, f236;
sub.f32 f238, %75, %115;
mul.f32 f239, f238, 0f3F737871;
sub.f32 f240, %88, %101;
fma.rn.f32 f241, f240, 0f3F167918, f239;
sub.f32 f242, f237, f241;
add.f32 f243, f241, f237;
mul.f32 f244, f227, 0f3F4F1BBD;
sub.f32 f245, %60, f244;
fma.rn.f32 f246, f229, 0f3E9E377A, f245;
mul.f32 f247, f238, 0f3F167918;
mul.f32 f248, f240, 0f3F737871;
sub.f32 f249, f247, f248;
sub.f32 f250, f246, f249;
add.f32 f251, f249, f246;
fma.rn.f32 f252, f231, 0f3E9E377A, %61;
mul.f32 f253, f233, 0f3F4F1BBD;
sub.f32 f254, f252, f253;
sub.f32 f255, %73, %113;
mul.f32 f256, f255, 0f3F737871;
sub.f32 f257, %86, %100;
fma.rn.f32 f258, f257, 0f3F167918, f256;
add.f32 f259, f258, f254;
sub.f32 f260, f254, f258;
mul.f32 f261, f231, 0f3F4F1BBD;
sub.f32 f262, %61, f261;
fma.rn.f32 f263, f233, 0f3E9E377A, f262;
mul.f32 f264, f255, 0f3F167918;
mul.f32 f265, f257, 0f3F737871;
sub.f32 f266, f264, f265;
add.f32 f267, f266, f263;
sub.f32 f268, f263, f266;
add.f32 f269, %76, %116;
add.f32 f270, %62, f269;
add.f32 f271, %89, %102;
add.f32 f272, f271, f270;
add.f32 f273, %77, %117;
add.f32 f274, %64, f273;
add.f32 f275, %91, %104;
add.f32 f276, f275, f274;
fma.rn.f32 f277, f269, 0f3E9E377A, %62;
mul.f32 f278, f271, 0f3F4F1BBD;
sub.f32 f279, f277, f278;
sub.f32 f280, %77, %117;
mul.f32 f281, f280, 0f3F737871;
sub.f32 f282, %91, %104;
fma.rn.f32 f283, f282, 0f3F167918, f281;
sub.f32 f284, f279, f283;
add.f32 f285, f283, f279;
mul.f32 f286, f269, 0f3F4F1BBD;
sub.f32 f287, %62, f286;
fma.rn.f32 f288, f271, 0f3E9E377A, f287;
mul.f32 f289, f280, 0f3F167918;
mul.f32 f290, f282, 0f3F737871;
sub.f32 f291, f289, f290;
sub.f32 f292, f288, f291;
add.f32 f293, f291, f288;
fma.rn.f32 f294, f273, 0f3E9E377A, %64;
mul.f32 f295, f275, 0f3F4F1BBD;
sub.f32 f296, f294, f295;
sub.f32 f297, %76, %116;
mul.f32 f298, f297, 0f3F737871;
sub.f32 f299, %89, %102;
fma.rn.f32 f300, f299, 0f3F167918, f298;
add.f32 f301, f300, f296;
sub.f32 f302, f296, f300;
mul.f32 f303, f273, 0f3F4F1BBD;
sub.f32 f304, %64, f303;
fma.rn.f32 f305, f275, 0f3E9E377A, f304;
mul.f32 f306, f297, 0f3F167918;
mul.f32 f307, f299, 0f3F737871;
sub.f32 f308, f306, f307;
add.f32 f309, f308, f305;
sub.f32 f310, f305, f308;
mov.u32 r4, %tid.x;
mul.f32 f311, f158, 0f3F77F511;
mul.f32 f312, f175, 0f3E7EA890;
sub.f32 f313, f311, f312;
mul.f32 f314, f175, 0f3F77F511;
fma.rn.f32 f315, f158, 0f3E7EA890, f314;
mul.f32 f316, f200, 0f3F6055A2;
mul.f32 f317, f217, 0f3EF6A86B;
sub.f32 f318, f316, f317;
mul.f32 f319, f217, 0f3F6055A2;
fma.rn.f32 f320, f200, 0f3EF6A86B, f319;
mul.f32 f321, f242, 0f3F3A9DB0;
mul.f32 f322, f259, 0f3F2F3E7B;
sub.f32 f323, f321, f322;
mul.f32 f324, f259, 0f3F3A9DB0;
fma.rn.f32 f325, f242, 0f3F2F3E7B, f324;
mul.f32 f326, f284, 0f3F092BF2;
mul.f32 f327, f301, 0f3F5825E0;
sub.f32 f328, f326, f327;
mul.f32 f329, f301, 0f3F092BF2;
fma.rn.f32 f330, f284, 0f3F5825E0, f329;
mul.f32 f331, f166, 0f3F6055A2;
mul.f32 f332, f183, 0f3EF6A86B;
sub.f32 f333, f331, f332;
mul.f32 f334, f183, 0f3F6055A2;
fma.rn.f32 f335, f166, 0f3EF6A86B, f334;
mul.f32 f336, f208, 0f3F092BF2;
mul.f32 f337, f225, 0f3F5825E0;
sub.f32 f338, f336, f337;
mul.f32 f339, f225, 0f3F092BF2;
fma.rn.f32 f340, f208, 0f3F5825E0, f339;
mul.f32 f341, f250, 0f3D809851;
mul.f32 f342, f267, 0f3F7F7EAE;
sub.f32 f343, f341, f342;
mul.f32 f344, f267, 0f3D809851;
fma.rn.f32 f345, f250, 0f3F7F7EAE, f344;
mul.f32 f346, f292, 0fBED9FFBE;
mul.f32 f347, f309, 0f3F67A2BF;
sub.f32 f348, f346, f347;
mul.f32 f349, f309, 0fBED9FFBE;
fma.rn.f32 f350, f292, 0f3F67A2BF, f349;
mul.f32 f351, f167, 0f3F3A9DB0;
mul.f32 f352, f184, 0f3F2F3E7B;
sub.f32 f353, f351, f352;
mul.f32 f354, f184, 0f3F3A9DB0;
fma.rn.f32 f355, f167, 0f3F2F3E7B, f354;
mul.f32 f356, f209, 0f3D809851;
mul.f32 f357, f226, 0f3F7F7EAE;
sub.f32 f358, f356, f357;
mul.f32 f359, f226, 0f3D809851;
fma.rn.f32 f360, f209, 0f3F7F7EAE, f359;
mul.f32 f361, f251, 0fBF232E38;
mul.f32 f362, f268, 0f3F45405B;
sub.f32 f363, f361, f362;
mul.f32 f364, f268, 0fBF232E38;
fma.rn.f32 f365, f251, 0f3F45405B, f364;
mul.f32 f366, f293, 0fBF7DFB3B;
mul.f32 f367, f310, 0f3E00575B;
sub.f32 f368, f366, f367;
mul.f32 f369, f310, 0fBF7DFB3B;
fma.rn.f32 f370, f293, 0f3E00575B, f369;
mul.f32 f371, f159, 0f3F092BF2;
mul.f32 f372, f176, 0f3F5825E0;
sub.f32 f373, f371, f372;
mul.f32 f374, f176, 0f3F092BF2;
fma.rn.f32 f375, f159, 0f3F5825E0, f374;
mul.f32 f376, f201, 0fBED9FFBE;
mul.f32 f377, f218, 0f3F67A2BF;
sub.f32 f378, f376, f377;
mul.f32 f379, f218, 0fBED9FFBE;
fma.rn.f32 f380, f201, 0f3F67A2BF, f379;
mul.f32 f381, f243, 0fBF7DFB3B;
mul.f32 f382, f260, 0f3E00575B;
sub.f32 f383, f381, f382;
mul.f32 f384, f260, 0fBF7DFB3B;
fma.rn.f32 f385, f243, 0f3E00575B, f384;
mul.f32 f386, f285, 0fBF232E38;
mul.f32 f387, f302, 0fBF45405B;
sub.f32 f388, f386, f387;
mul.f32 f389, f302, 0fBF232E38;
fma.rn.f32 f390, f285, 0fBF45405B, f389;
add.f32 f391, f146, f272;
add.f32 f392, f104, f391;
add.f32 f393, f188, f230;
add.f32 f394, f393, f392;
add.f32 f395, f150, f276;
add.f32 f396, f108, f395;
add.f32 f397, f192, f234;
add.f32 f398, f397, f396;
fma.rn.f32 f399, f391, 0f3E9E377A, f104;
mul.f32 f400, f393, 0f3F4F1BBD;
sub.f32 f401, f399, f400;
sub.f32 f402, f150, f276;
mul.f32 f403, f402, 0f3F737871;
sub.f32 f404, f192, f234;
fma.rn.f32 f405, f404, 0f3F167918, f403;
sub.f32 f406, f401, f405;
add.f32 f407, f405, f401;
mul.f32 f408, f391, 0f3F4F1BBD;
sub.f32 f409, f104, f408;
fma.rn.f32 f410, f393, 0f3E9E377A, f409;
mul.f32 f411, f402, 0f3F167918;
mul.f32 f412, f404, 0f3F737871;
sub.f32 f413, f411, f412;
sub.f32 f414, f410, f413;
add.f32 f415, f413, f410;
fma.rn.f32 f416, f395, 0f3E9E377A, f108;
mul.f32 f417, f397, 0f3F4F1BBD;
sub.f32 f418, f416, f417;
sub.f32 f419, f146, f272;
mul.f32 f420, f419, 0f3F737871;
sub.f32 f421, f188, f230;
fma.rn.f32 f422, f421, 0f3F167918, f420;
add.f32 f423, f422, f418;
sub.f32 f424, f418, f422;
mul.f32 f425, f395, 0f3F4F1BBD;
sub.f32 f426, f108, f425;
fma.rn.f32 f427, f397, 0f3E9E377A, f426;
mul.f32 f428, f419, 0f3F167918;
mul.f32 f429, f421, 0f3F737871;
sub.f32 f430, f428, f429;
add.f32 f431, f430, f427;
sub.f32 f432, f427, f430;
add.f32 f433, f313, f328;
add.f32 f434, f116, f433;
add.f32 f435, f318, f323;
add.f32 f436, f435, f434;
add.f32 f437, f315, f330;
add.f32 f438, f133, f437;
add.f32 f439, f320, f325;
add.f32 f440, f439, f438;
fma.rn.f32 f441, f433, 0f3E9E377A, f116;
mul.f32 f442, f435, 0f3F4F1BBD;
sub.f32 f443, f441, f442;
sub.f32 f444, f315, f330;
mul.f32 f445, f444, 0f3F737871;
sub.f32 f446, f320, f325;
fma.rn.f32 f447, f446, 0f3F167918, f445;
sub.f32 f448, f443, f447;
add.f32 f449, f447, f443;
mul.f32 f450, f433, 0f3F4F1BBD;
sub.f32 f451, f116, f450;
fma.rn.f32 f452, f435, 0f3E9E377A, f451;
mul.f32 f453, f444, 0f3F167918;
mul.f32 f454, f446, 0f3F737871;
sub.f32 f455, f453, f454;
sub.f32 f456, f452, f455;
add.f32 f457, f455, f452;
fma.rn.f32 f458, f437, 0f3E9E377A, f133;
mul.f32 f459, f439, 0f3F4F1BBD;
sub.f32 f460, f458, f459;
sub.f32 f461, f313, f328;
mul.f32 f462, f461, 0f3F737871;
sub.f32 f463, f318, f323;
fma.rn.f32 f464, f463, 0f3F167918, f462;
add.f32 f465, f464, f460;
sub.f32 f466, f460, f464;
mul.f32 f467, f437, 0f3F4F1BBD;
sub.f32 f468, f133, f467;
fma.rn.f32 f469, f439, 0f3E9E377A, f468;
mul.f32 f470, f461, 0f3F167918;
mul.f32 f471, f463, 0f3F737871;
sub.f32 f472, f470, f471;
add.f32 f473, f472, f469;
sub.f32 f474, f469, f472;
add.f32 f475, f333, f348;
add.f32 f476, f124, f475;
add.f32 f477, f338, f343;
add.f32 f478, f477, f476;
add.f32 f479, f335, f350;
add.f32 f480, f141, f479;
add.f32 f481, f340, f345;
add.f32 f482, f481, f480;
fma.rn.f32 f483, f475, 0f3E9E377A, f124;
mul.f32 f484, f477, 0f3F4F1BBD;
sub.f32 f485, f483, f484;
sub.f32 f486, f335, f350;
mul.f32 f487, f486, 0f3F737871;
sub.f32 f488, f340, f345;
fma.rn.f32 f489, f488, 0f3F167918, f487;
sub.f32 f490, f485, f489;
add.f32 f491, f489, f485;
mul.f32 f492, f475, 0f3F4F1BBD;
sub.f32 f493, f124, f492;
fma.rn.f32 f494, f477, 0f3E9E377A, f493;
mul.f32 f495, f486, 0f3F167918;
mul.f32 f496, f488, 0f3F737871;
sub.f32 f497, f495, f496;
sub.f32 f498, f494, f497;
add.f32 f499, f497, f494;
fma.rn.f32 f500, f479, 0f3E9E377A, f141;
mul.f32 f501, f481, 0f3F4F1BBD;
sub.f32 f502, f500, f501;
sub.f32 f503, f333, f348;
mul.f32 f504, f503, 0f3F737871;
sub.f32 f505, f338, f343;
fma.rn.f32 f506, f505, 0f3F167918, f504;
add.f32 f507, f506, f502;
sub.f32 f508, f502, f506;
mul.f32 f509, f479, 0f3F4F1BBD;
sub.f32 f510, f141, f509;
fma.rn.f32 f511, f481, 0f3E9E377A, f510;
mul.f32 f512, f503, 0f3F167918;
mul.f32 f513, f505, 0f3F737871;
sub.f32 f514, f512, f513;
add.f32 f515, f514, f511;
sub.f32 f516, f511, f514;
add.f32 f517, f353, f368;
add.f32 f518, f125, f517;
add.f32 f519, f358, f363;
add.f32 f520, f519, f518;
add.f32 f521, f355, f370;
add.f32 f522, f142, f521;
add.f32 f523, f360, f365;
add.f32 f524, f523, f522;
fma.rn.f32 f525, f517, 0f3E9E377A, f125;
mul.f32 f526, f519, 0f3F4F1BBD;
sub.f32 f527, f525, f526;
sub.f32 f528, f355, f370;
mul.f32 f529, f528, 0f3F737871;
sub.f32 f530, f360, f365;
fma.rn.f32 f531, f530, 0f3F167918, f529;
sub.f32 f532, f527, f531;
add.f32 f533, f531, f527;
mul.f32 f534, f517, 0f3F4F1BBD;
sub.f32 f535, f125, f534;
fma.rn.f32 f536, f519, 0f3E9E377A, f535;
mul.f32 f537, f528, 0f3F167918;
mul.f32 f538, f530, 0f3F737871;
sub.f32 f539, f537, f538;
sub.f32 f540, f536, f539;
add.f32 f541, f539, f536;
fma.rn.f32 f542, f521, 0f3E9E377A, f142;
mul.f32 f543, f523, 0f3F4F1BBD;
sub.f32 f544, f542, f543;
sub.f32 f545, f353, f368;
mul.f32 f546, f545, 0f3F737871;
sub.f32 f547, f358, f363;
fma.rn.f32 f548, f547, 0f3F167918, f546;
add.f32 f549, f548, f544;
sub.f32 f550, f544, f548;
mul.f32 f551, f521, 0f3F4F1BBD;
sub.f32 f552, f142, f551;
fma.rn.f32 f553, f523, 0f3E9E377A, f552;
mul.f32 f554, f545, 0f3F167918;
mul.f32 f555, f547, 0f3F737871;
sub.f32 f556, f554, f555;
add.f32 f557, f556, f553;
sub.f32 f558, f553, f556;
add.f32 f559, f373, f388;
add.f32 f560, f117, f559;
add.f32 f561, f378, f383;
add.f32 f562, f561, f560;
add.f32 f563, f375, f390;
add.f32 f564, f134, f563;
add.f32 f565, f380, f385;
add.f32 f566, f565, f564;
fma.rn.f32 f567, f559, 0f3E9E377A, f117;
mul.f32 f568, f561, 0f3F4F1BBD;
sub.f32 f569, f567, f568;
sub.f32 f570, f375, f390;
mul.f32 f571, f570, 0f3F737871;
sub.f32 f572, f380, f385;
fma.rn.f32 f573, f572, 0f3F167918, f571;
sub.f32 f574, f569, f573;
add.f32 f575, f573, f569;
mul.f32 f576, f559, 0f3F4F1BBD;
sub.f32 f577, f117, f576;
fma.rn.f32 f578, f561, 0f3E9E377A, f577;
mul.f32 f579, f570, 0f3F167918;
mul.f32 f580, f572, 0f3F737871;
sub.f32 f581, f579, f580;
sub.f32 f582, f578, f581;
add.f32 f583, f581, f578;
fma.rn.f32 f584, f563, 0f3E9E377A, f134;
mul.f32 f585, f565, 0f3F4F1BBD;
sub.f32 f586, f584, f585;
sub.f32 f587, f373, f388;
mul.f32 f588, f587, 0f3F737871;
sub.f32 f589, f378, f383;
fma.rn.f32 f590, f589, 0f3F167918, f588;
add.f32 f591, f590, f586;
sub.f32 f592, f586, f590;
mul.f32 f593, f563, 0f3F4F1BBD;
sub.f32 f594, f134, f593;
fma.rn.f32 f595, f565, 0f3E9E377A, f594;
mul.f32 f596, f587, 0f3F167918;
mul.f32 f597, f589, 0f3F737871;
sub.f32 f598, f596, f597;
add.f32 f599, f598, f595;
sub.f32 f600, f595, f598;
mul.wide.u32 rd2, r4, 1374389535;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 25;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %51;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f601, f602}, [rd6];
mul.f32 f605, f440, f602;
fma.rn.f32 f606, f601, f436, f605;
mul.f32 f607, f436, f602;
mul.f32 f608, f601, f440;
sub.f32 f609, f608, f607;
mul.f32 f610, f601, f601;
mul.f32 f611, f602, f602;
sub.f32 f612, f610, f611;
mul.f32 f613, f602, f601;
fma.rn.f32 f614, f602, f601, f613;
mul.f32 f615, f482, f614;
fma.rn.f32 f616, f612, f478, f615;
mul.f32 f617, f478, f614;
mul.f32 f618, f612, f482;
sub.f32 f619, f618, f617;
mul.f32 f620, f601, f612;
mul.f32 f621, f602, f614;
sub.f32 f622, f620, f621;
mul.f32 f623, f601, f614;
fma.rn.f32 f624, f602, f612, f623;
mul.f32 f625, f524, f624;
fma.rn.f32 f626, f622, f520, f625;
mul.f32 f627, f520, f624;
mul.f32 f628, f622, f524;
sub.f32 f629, f628, f627;
mul.f32 f630, f601, f622;
mul.f32 f631, f602, f624;
sub.f32 f632, f630, f631;
mul.f32 f633, f601, f624;
fma.rn.f32 f634, f602, f622, f633;
mul.f32 f635, f566, f634;
fma.rn.f32 f636, f632, f562, f635;
mul.f32 f637, f562, f634;
mul.f32 f638, f632, f566;
sub.f32 f639, f638, f637;
mul.f32 f640, f601, f632;
mul.f32 f641, f602, f634;
sub.f32 f642, f640, f641;
mul.f32 f643, f601, f634;
fma.rn.f32 f644, f602, f632, f643;
mul.f32 f645, f423, f644;
fma.rn.f32 f646, f642, f406, f645;
mul.f32 f647, f406, f644;
mul.f32 f648, f642, f423;
sub.f32 f649, f648, f647;
mul.f32 f650, f601, f642;
mul.f32 f651, f602, f644;
sub.f32 f652, f650, f651;
mul.f32 f653, f601, f644;
fma.rn.f32 f654, f602, f642, f653;
mul.f32 f655, f465, f654;
fma.rn.f32 f656, f652, f448, f655;
mul.f32 f657, f448, f654;
mul.f32 f658, f652, f465;
sub.f32 f659, f658, f657;
mul.f32 f660, f601, f652;
mul.f32 f661, f602, f654;
sub.f32 f662, f660, f661;
mul.f32 f663, f601, f654;
fma.rn.f32 f664, f602, f652, f663;
mul.f32 f665, f507, f664;
fma.rn.f32 f666, f662, f490, f665;
mul.f32 f667, f490, f664;
mul.f32 f668, f662, f507;
sub.f32 f669, f668, f667;
mul.f32 f670, f601, f662;
mul.f32 f671, f602, f664;
sub.f32 f672, f670, f671;
mul.f32 f673, f601, f664;
fma.rn.f32 f674, f602, f662, f673;
mul.f32 f675, f549, f674;
fma.rn.f32 f676, f672, f532, f675;
mul.f32 f677, f532, f674;
mul.f32 f678, f672, f549;
sub.f32 f679, f678, f677;
mul.f32 f680, f601, f672;
mul.f32 f681, f602, f674;
sub.f32 f682, f680, f681;
mul.f32 f683, f601, f674;
fma.rn.f32 f684, f602, f672, f683;
mul.f32 f685, f591, f684;
fma.rn.f32 f686, f682, f574, f685;
mul.f32 f687, f574, f684;
mul.f32 f688, f682, f591;
sub.f32 f689, f688, f687;
mul.f32 f690, f601, f682;
mul.f32 f691, f602, f684;
sub.f32 f692, f690, f691;
mul.f32 f693, f601, f684;
fma.rn.f32 f694, f602, f682, f693;
mul.f32 f695, f431, f694;
fma.rn.f32 f696, f692, f414, f695;
mul.f32 f697, f414, f694;
mul.f32 f698, f692, f431;
sub.f32 f699, f698, f697;
mul.f32 f700, f601, f692;
mul.f32 f701, f602, f694;
sub.f32 f702, f700, f701;
mul.f32 f703, f601, f694;
fma.rn.f32 f704, f602, f692, f703;
mul.f32 f705, f473, f704;
fma.rn.f32 f706, f702, f456, f705;
mul.f32 f707, f456, f704;
mul.f32 f708, f702, f473;
sub.f32 f709, f708, f707;
mul.f32 f710, f601, f702;
mul.f32 f711, f602, f704;
sub.f32 f712, f710, f711;
mul.f32 f713, f601, f704;
fma.rn.f32 f714, f602, f702, f713;
mul.f32 f715, f515, f714;
fma.rn.f32 f716, f712, f498, f715;
mul.f32 f717, f498, f714;
mul.f32 f718, f712, f515;
sub.f32 f719, f718, f717;
mul.f32 f720, f601, f712;
mul.f32 f721, f602, f714;
sub.f32 f722, f720, f721;
mul.f32 f723, f601, f714;
fma.rn.f32 f724, f602, f712, f723;
mul.f32 f725, f557, f724;
fma.rn.f32 f726, f722, f540, f725;
mul.f32 f727, f540, f724;
mul.f32 f728, f722, f557;
sub.f32 f729, f728, f727;
mul.f32 f730, f601, f722;
mul.f32 f731, f602, f724;
sub.f32 f732, f730, f731;
mul.f32 f733, f601, f724;
fma.rn.f32 f734, f602, f722, f733;
mul.f32 f735, f599, f734;
fma.rn.f32 f736, f732, f582, f735;
mul.f32 f737, f582, f734;
mul.f32 f738, f732, f599;
sub.f32 f739, f738, f737;
mul.f32 f740, f601, f732;
mul.f32 f741, f602, f734;
sub.f32 f742, f740, f741;
mul.f32 f743, f601, f734;
fma.rn.f32 f744, f602, f732, f743;
mul.f32 f745, f432, f744;
fma.rn.f32 f746, f742, f415, f745;
mul.f32 f747, f415, f744;
mul.f32 f748, f742, f432;
sub.f32 f749, f748, f747;
mul.f32 f750, f601, f742;
mul.f32 f751, f602, f744;
sub.f32 f752, f750, f751;
mul.f32 f753, f601, f744;
fma.rn.f32 f754, f602, f742, f753;
mul.f32 f755, f474, f754;
fma.rn.f32 f756, f752, f457, f755;
mul.f32 f757, f457, f754;
mul.f32 f758, f752, f474;
sub.f32 f759, f758, f757;
mul.f32 f760, f601, f752;
mul.f32 f761, f602, f754;
sub.f32 f762, f760, f761;
mul.f32 f763, f601, f754;
fma.rn.f32 f764, f602, f752, f763;
mul.f32 f765, f516, f764;
fma.rn.f32 f766, f762, f499, f765;
mul.f32 f767, f499, f764;
mul.f32 f768, f762, f516;
sub.f32 f769, f768, f767;
mul.f32 f770, f601, f762;
mul.f32 f771, f602, f764;
sub.f32 f772, f770, f771;
mul.f32 f773, f601, f764;
fma.rn.f32 f774, f602, f762, f773;
mul.f32 f775, f558, f774;
fma.rn.f32 f776, f772, f541, f775;
mul.f32 f777, f541, f774;
mul.f32 f778, f772, f558;
sub.f32 f779, f778, f777;
mul.f32 f780, f601, f772;
mul.f32 f781, f602, f774;
sub.f32 f782, f780, f781;
mul.f32 f783, f601, f774;
fma.rn.f32 f784, f602, f772, f783;
mul.f32 f785, f600, f784;
fma.rn.f32 f786, f782, f583, f785;
mul.f32 f787, f583, f784;
mul.f32 f788, f782, f600;
sub.f32 f789, f788, f787;
mul.f32 f790, f601, f782;
mul.f32 f791, f602, f784;
sub.f32 f792, f790, f791;
mul.f32 f793, f601, f784;
fma.rn.f32 f794, f602, f782, f793;
mul.f32 f795, f424, f794;
fma.rn.f32 f796, f792, f407, f795;
mul.f32 f797, f407, f794;
mul.f32 f798, f792, f424;
sub.f32 f799, f798, f797;
mul.f32 f800, f601, f792;
mul.f32 f801, f602, f794;
sub.f32 f802, f800, f801;
mul.f32 f803, f601, f794;
fma.rn.f32 f804, f602, f792, f803;
mul.f32 f805, f466, f804;
fma.rn.f32 f806, f802, f449, f805;
mul.f32 f807, f449, f804;
mul.f32 f808, f802, f466;
sub.f32 f809, f808, f807;
mul.f32 f810, f601, f802;
mul.f32 f811, f602, f804;
sub.f32 f812, f810, f811;
mul.f32 f813, f601, f804;
fma.rn.f32 f814, f602, f802, f813;
mul.f32 f815, f508, f814;
fma.rn.f32 f816, f812, f491, f815;
mul.f32 f817, f491, f814;
mul.f32 f818, f812, f508;
sub.f32 f819, f818, f817;
mul.f32 f820, f601, f812;
mul.f32 f821, f602, f814;
sub.f32 f822, f820, f821;
mul.f32 f823, f601, f814;
fma.rn.f32 f824, f602, f812, f823;
mul.f32 f825, f550, f824;
fma.rn.f32 f826, f822, f533, f825;
mul.f32 f827, f533, f824;
mul.f32 f828, f822, f550;
sub.f32 f829, f828, f827;
mul.f32 f830, f601, f822;
mul.f32 f831, f602, f824;
sub.f32 f832, f830, f831;
mul.f32 f833, f601, f824;
fma.rn.f32 f834, f602, f822, f833;
mul.f32 f835, f592, f834;
fma.rn.f32 f836, f832, f575, f835;
mul.f32 f837, f575, f834;
mul.f32 f838, f832, f592;
sub.f32 f839, f838, f837;
mad.lo.s32 r8, r5, 2500, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 100, r8;
st.shared.f32 [r9], f394;
st.shared.f32 [r9+4], f606;
st.shared.f32 [r9+8], f616;
st.shared.f32 [r9+12], f626;
st.shared.f32 [r9+16], f636;
st.shared.f32 [r9+20], f646;
st.shared.f32 [r9+24], f656;
st.shared.f32 [r9+28], f666;
st.shared.f32 [r9+32], f676;
st.shared.f32 [r9+36], f686;
st.shared.f32 [r9+40], f696;
st.shared.f32 [r9+44], f706;
st.shared.f32 [r9+48], f716;
st.shared.f32 [r9+52], f726;
st.shared.f32 [r9+56], f736;
st.shared.f32 [r9+60], f746;
st.shared.f32 [r9+64], f756;
st.shared.f32 [r9+68], f766;
st.shared.f32 [r9+72], f776;
st.shared.f32 [r9+76], f786;
st.shared.f32 [r9+80], f796;
st.shared.f32 [r9+84], f806;
st.shared.f32 [r9+88], f816;
st.shared.f32 [r9+92], f826;
st.shared.f32 [r9+96], f836;
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.f32 f840, [r10];
ld.shared.f32 f841, [r10+100];
ld.shared.f32 f842, [r10+200];
ld.shared.f32 f843, [r10+300];
ld.shared.f32 f844, [r10+400];
ld.shared.f32 f845, [r10+500];
ld.shared.f32 f846, [r10+600];
ld.shared.f32 f847, [r10+700];
ld.shared.f32 f848, [r10+800];
ld.shared.f32 f849, [r10+900];
ld.shared.f32 f850, [r10+1000];
ld.shared.f32 f851, [r10+1100];
ld.shared.f32 f852, [r10+1200];
ld.shared.f32 f853, [r10+1300];
ld.shared.f32 f854, [r10+1400];
ld.shared.f32 f855, [r10+1500];
ld.shared.f32 f856, [r10+1600];
ld.shared.f32 f857, [r10+1700];
ld.shared.f32 f858, [r10+1800];
ld.shared.f32 f859, [r10+1900];
ld.shared.f32 f860, [r10+2000];
ld.shared.f32 f861, [r10+2100];
ld.shared.f32 f862, [r10+2200];
ld.shared.f32 f863, [r10+2300];
ld.shared.f32 f864, [r10+2400];
barrier.sync 0;
st.shared.f32 [r9], f398;
st.shared.f32 [r9+4], f609;
st.shared.f32 [r9+8], f619;
st.shared.f32 [r9+12], f629;
st.shared.f32 [r9+16], f639;
st.shared.f32 [r9+20], f649;
st.shared.f32 [r9+24], f659;
st.shared.f32 [r9+28], f669;
st.shared.f32 [r9+32], f679;
st.shared.f32 [r9+36], f689;
st.shared.f32 [r9+40], f699;
st.shared.f32 [r9+44], f709;
st.shared.f32 [r9+48], f719;
st.shared.f32 [r9+52], f729;
st.shared.f32 [r9+56], f739;
st.shared.f32 [r9+60], f749;
st.shared.f32 [r9+64], f759;
st.shared.f32 [r9+68], f769;
st.shared.f32 [r9+72], f779;
st.shared.f32 [r9+76], f789;
st.shared.f32 [r9+80], f799;
st.shared.f32 [r9+84], f809;
st.shared.f32 [r9+88], f819;
st.shared.f32 [r9+92], f829;
st.shared.f32 [r9+96], f839;
barrier.sync 0;
ld.shared.f32 f865, [r10];
ld.shared.f32 f866, [r10+100];
ld.shared.f32 f867, [r10+200];
ld.shared.f32 f868, [r10+300];
ld.shared.f32 f869, [r10+400];
ld.shared.f32 f870, [r10+500];
ld.shared.f32 f871, [r10+600];
ld.shared.f32 f872, [r10+700];
ld.shared.f32 f873, [r10+800];
ld.shared.f32 f874, [r10+900];
ld.shared.f32 f875, [r10+1000];
ld.shared.f32 f876, [r10+1100];
ld.shared.f32 f877, [r10+1200];
ld.shared.f32 f878, [r10+1300];
ld.shared.f32 f879, [r10+1400];
ld.shared.f32 f880, [r10+1500];
ld.shared.f32 f881, [r10+1600];
ld.shared.f32 f882, [r10+1700];
ld.shared.f32 f883, [r10+1800];
ld.shared.f32 f884, [r10+1900];
ld.shared.f32 f885, [r10+2000];
ld.shared.f32 f886, [r10+2100];
ld.shared.f32 f887, [r10+2200];
ld.shared.f32 f888, [r10+2300];
ld.shared.f32 f889, [r10+2400];
add.f32 f890, f845, f860;
add.f32 f891, f840, f890;
add.f32 f892, f850, f855;
add.f32 f893, f892, f891;
add.f32 f894, f870, f885;
add.f32 f895, f865, f894;
add.f32 f896, f875, f880;
add.f32 f897, f896, f895;
fma.rn.f32 f898, f890, 0f3E9E377A, f840;
mul.f32 f899, f892, 0f3F4F1BBD;
sub.f32 f900, f898, f899;
sub.f32 f901, f870, f885;
mul.f32 f902, f901, 0f3F737871;
sub.f32 f903, f875, f880;
fma.rn.f32 f904, f903, 0f3F167918, f902;
sub.f32 f905, f900, f904;
add.f32 f906, f904, f900;
mul.f32 f907, f890, 0f3F4F1BBD;
sub.f32 f908, f840, f907;
fma.rn.f32 f909, f892, 0f3E9E377A, f908;
mul.f32 f910, f901, 0f3F167918;
mul.f32 f911, f903, 0f3F737871;
sub.f32 f912, f910, f911;
sub.f32 f913, f909, f912;
add.f32 f914, f912, f909;
fma.rn.f32 f915, f894, 0f3E9E377A, f865;
mul.f32 f916, f896, 0f3F4F1BBD;
sub.f32 f917, f915, f916;
sub.f32 f918, f845, f860;
mul.f32 f919, f918, 0f3F737871;
sub.f32 f920, f850, f855;
fma.rn.f32 f921, f920, 0f3F167918, f919;
add.f32 f922, f921, f917;
sub.f32 f923, f917, f921;
mul.f32 f924, f894, 0f3F4F1BBD;
sub.f32 f925, f865, f924;
fma.rn.f32 f926, f896, 0f3E9E377A, f925;
mul.f32 f927, f918, 0f3F167918;
mul.f32 f928, f920, 0f3F737871;
sub.f32 f929, f927, f928;
add.f32 f930, f929, f926;
sub.f32 f931, f926, f929;
add.f32 f932, f846, f861;
add.f32 f933, f841, f932;
add.f32 f934, f851, f856;
add.f32 f935, f934, f933;
add.f32 f936, f871, f886;
add.f32 f937, f866, f936;
add.f32 f938, f876, f881;
add.f32 f939, f938, f937;
fma.rn.f32 f940, f932, 0f3E9E377A, f841;
mul.f32 f941, f934, 0f3F4F1BBD;
sub.f32 f942, f940, f941;
sub.f32 f943, f871, f886;
mul.f32 f944, f943, 0f3F737871;
sub.f32 f945, f876, f881;
fma.rn.f32 f946, f945, 0f3F167918, f944;
sub.f32 f947, f942, f946;
add.f32 f948, f946, f942;
mul.f32 f949, f932, 0f3F4F1BBD;
sub.f32 f950, f841, f949;
fma.rn.f32 f951, f934, 0f3E9E377A, f950;
mul.f32 f952, f943, 0f3F167918;
mul.f32 f953, f945, 0f3F737871;
sub.f32 f954, f952, f953;
sub.f32 f955, f951, f954;
add.f32 f956, f954, f951;
fma.rn.f32 f957, f936, 0f3E9E377A, f866;
mul.f32 f958, f938, 0f3F4F1BBD;
sub.f32 f959, f957, f958;
sub.f32 f960, f846, f861;
mul.f32 f961, f960, 0f3F737871;
sub.f32 f962, f851, f856;
fma.rn.f32 f963, f962, 0f3F167918, f961;
add.f32 f964, f963, f959;
sub.f32 f965, f959, f963;
mul.f32 f966, f936, 0f3F4F1BBD;
sub.f32 f967, f866, f966;
fma.rn.f32 f968, f938, 0f3E9E377A, f967;
mul.f32 f969, f960, 0f3F167918;
mul.f32 f970, f962, 0f3F737871;
sub.f32 f971, f969, f970;
add.f32 f972, f971, f968;
sub.f32 f973, f968, f971;
add.f32 f974, f847, f862;
add.f32 f975, f842, f974;
add.f32 f976, f852, f857;
add.f32 f977, f976, f975;
add.f32 f978, f872, f887;
add.f32 f979, f867, f978;
add.f32 f980, f877, f882;
add.f32 f981, f980, f979;
fma.rn.f32 f982, f974, 0f3E9E377A, f842;
mul.f32 f983, f976, 0f3F4F1BBD;
sub.f32 f984, f982, f983;
sub.f32 f985, f872, f887;
mul.f32 f986, f985, 0f3F737871;
sub.f32 f987, f877, f882;
fma.rn.f32 f988, f987, 0f3F167918, f986;
sub.f32 f989, f984, f988;
add.f32 f990, f988, f984;
mul.f32 f991, f974, 0f3F4F1BBD;
sub.f32 f992, f842, f991;
fma.rn.f32 f993, f976, 0f3E9E377A, f992;
mul.f32 f994, f985, 0f3F167918;
mul.f32 f995, f987, 0f3F737871;
sub.f32 f996, f994, f995;
sub.f32 f997, f993, f996;
add.f32 f998, f996, f993;
fma.rn.f32 f999, f978, 0f3E9E377A, f867;
mul.f32 f1000, f980, 0f3F4F1BBD;
sub.f32 f1001, f999, f1000;
sub.f32 f1002, f847, f862;
mul.f32 f1003, f1002, 0f3F737871;
sub.f32 f1004, f852, f857;
fma.rn.f32 f1005, f1004, 0f3F167918, f1003;
add.f32 f1006, f1005, f1001;
sub.f32 f1007, f1001, f1005;
mul.f32 f1008, f978, 0f3F4F1BBD;
sub.f32 f1009, f867, f1008;
fma.rn.f32 f1010, f980, 0f3E9E377A, f1009;
mul.f32 f1011, f1002, 0f3F167918;
mul.f32 f1012, f1004, 0f3F737871;
sub.f32 f1013, f1011, f1012;
add.f32 f1014, f1013, f1010;
sub.f32 f1015, f1010, f1013;
add.f32 f1016, f848, f863;
add.f32 f1017, f843, f1016;
add.f32 f1018, f853, f858;
add.f32 f1019, f1018, f1017;
add.f32 f1020, f873, f888;
add.f32 f1021, f868, f1020;
add.f32 f1022, f878, f883;
add.f32 f1023, f1022, f1021;
fma.rn.f32 f1024, f1016, 0f3E9E377A, f843;
mul.f32 f1025, f1018, 0f3F4F1BBD;
sub.f32 f1026, f1024, f1025;
sub.f32 f1027, f873, f888;
mul.f32 f1028, f1027, 0f3F737871;
sub.f32 f1029, f878, f883;
fma.rn.f32 f1030, f1029, 0f3F167918, f1028;
sub.f32 f1031, f1026, f1030;
add.f32 f1032, f1030, f1026;
mul.f32 f1033, f1016, 0f3F4F1BBD;
sub.f32 f1034, f843, f1033;
fma.rn.f32 f1035, f1018, 0f3E9E377A, f1034;
mul.f32 f1036, f1027, 0f3F167918;
mul.f32 f1037, f1029, 0f3F737871;
sub.f32 f1038, f1036, f1037;
sub.f32 f1039, f1035, f1038;
add.f32 f1040, f1038, f1035;
fma.rn.f32 f1041, f1020, 0f3E9E377A, f868;
mul.f32 f1042, f1022, 0f3F4F1BBD;
sub.f32 f1043, f1041, f1042;
sub.f32 f1044, f848, f863;
mul.f32 f1045, f1044, 0f3F737871;
sub.f32 f1046, f853, f858;
fma.rn.f32 f1047, f1046, 0f3F167918, f1045;
add.f32 f1048, f1047, f1043;
sub.f32 f1049, f1043, f1047;
mul.f32 f1050, f1020, 0f3F4F1BBD;
sub.f32 f1051, f868, f1050;
fma.rn.f32 f1052, f1022, 0f3E9E377A, f1051;
mul.f32 f1053, f1044, 0f3F167918;
mul.f32 f1054, f1046, 0f3F737871;
sub.f32 f1055, f1053, f1054;
add.f32 f1056, f1055, f1052;
sub.f32 f1057, f1052, f1055;
add.f32 f1058, f849, f864;
add.f32 f1059, f844, f1058;
add.f32 f1060, f854, f859;
add.f32 f1061, f1060, f1059;
add.f32 f1062, f874, f889;
add.f32 f1063, f869, f1062;
add.f32 f1064, f879, f884;
add.f32 f1065, f1064, f1063;
fma.rn.f32 f1066, f1058, 0f3E9E377A, f844;
mul.f32 f1067, f1060, 0f3F4F1BBD;
sub.f32 f1068, f1066, f1067;
sub.f32 f1069, f874, f889;
mul.f32 f1070, f1069, 0f3F737871;
sub.f32 f1071, f879, f884;
fma.rn.f32 f1072, f1071, 0f3F167918, f1070;
sub.f32 f1073, f1068, f1072;
add.f32 f1074, f1072, f1068;
mul.f32 f1075, f1058, 0f3F4F1BBD;
sub.f32 f1076, f844, f1075;
fma.rn.f32 f1077, f1060, 0f3E9E377A, f1076;
mul.f32 f1078, f1069, 0f3F167918;
mul.f32 f1079, f1071, 0f3F737871;
sub.f32 f1080, f1078, f1079;
sub.f32 f1081, f1077, f1080;
add.f32 f1082, f1080, f1077;
fma.rn.f32 f1083, f1062, 0f3E9E377A, f869;
mul.f32 f1084, f1064, 0f3F4F1BBD;
sub.f32 f1085, f1083, f1084;
sub.f32 f1086, f849, f864;
mul.f32 f1087, f1086, 0f3F737871;
sub.f32 f1088, f854, f859;
fma.rn.f32 f1089, f1088, 0f3F167918, f1087;
add.f32 f1090, f1089, f1085;
sub.f32 f1091, f1085, f1089;
mul.f32 f1092, f1062, 0f3F4F1BBD;
sub.f32 f1093, f869, f1092;
fma.rn.f32 f1094, f1064, 0f3E9E377A, f1093;
mul.f32 f1095, f1086, 0f3F167918;
mul.f32 f1096, f1088, 0f3F737871;
sub.f32 f1097, f1095, f1096;
add.f32 f1098, f1097, f1094;
sub.f32 f1099, f1094, f1097;
mul.f32 f1100, f947, 0f3F77F511;
mul.f32 f1101, f964, 0f3E7EA890;
sub.f32 f1102, f1100, f1101;
mul.f32 f1103, f964, 0f3F77F511;
fma.rn.f32 f1104, f947, 0f3E7EA890, f1103;
mul.f32 f1105, f989, 0f3F6055A2;
mul.f32 f1106, f1006, 0f3EF6A86B;
sub.f32 f1107, f1105, f1106;
mul.f32 f1108, f1006, 0f3F6055A2;
fma.rn.f32 f1109, f989, 0f3EF6A86B, f1108;
mul.f32 f1110, f1031, 0f3F3A9DB0;
mul.f32 f1111, f1048, 0f3F2F3E7B;
sub.f32 f1112, f1110, f1111;
mul.f32 f1113, f1048, 0f3F3A9DB0;
fma.rn.f32 f1114, f1031, 0f3F2F3E7B, f1113;
mul.f32 f1115, f1073, 0f3F092BF2;
mul.f32 f1116, f1090, 0f3F5825E0;
sub.f32 f1117, f1115, f1116;
mul.f32 f1118, f1090, 0f3F092BF2;
fma.rn.f32 f1119, f1073, 0f3F5825E0, f1118;
mul.f32 f1120, f955, 0f3F6055A2;
mul.f32 f1121, f972, 0f3EF6A86B;
sub.f32 f1122, f1120, f1121;
mul.f32 f1123, f972, 0f3F6055A2;
fma.rn.f32 f1124, f955, 0f3EF6A86B, f1123;
mul.f32 f1125, f997, 0f3F092BF2;
mul.f32 f1126, f1014, 0f3F5825E0;
sub.f32 f1127, f1125, f1126;
mul.f32 f1128, f1014, 0f3F092BF2;
fma.rn.f32 f1129, f997, 0f3F5825E0, f1128;
mul.f32 f1130, f1039, 0f3D809851;
mul.f32 f1131, f1056, 0f3F7F7EAE;
sub.f32 f1132, f1130, f1131;
mul.f32 f1133, f1056, 0f3D809851;
fma.rn.f32 f1134, f1039, 0f3F7F7EAE, f1133;
mul.f32 f1135, f1081, 0fBED9FFBE;
mul.f32 f1136, f1098, 0f3F67A2BF;
sub.f32 f1137, f1135, f1136;
mul.f32 f1138, f1098, 0fBED9FFBE;
fma.rn.f32 f1139, f1081, 0f3F67A2BF, f1138;
mul.f32 f1140, f956, 0f3F3A9DB0;
mul.f32 f1141, f973, 0f3F2F3E7B;
sub.f32 f1142, f1140, f1141;
mul.f32 f1143, f973, 0f3F3A9DB0;
fma.rn.f32 f1144, f956, 0f3F2F3E7B, f1143;
mul.f32 f1145, f998, 0f3D809851;
mul.f32 f1146, f1015, 0f3F7F7EAE;
sub.f32 f1147, f1145, f1146;
mul.f32 f1148, f1015, 0f3D809851;
fma.rn.f32 f1149, f998, 0f3F7F7EAE, f1148;
mul.f32 f1150, f1040, 0fBF232E38;
mul.f32 f1151, f1057, 0f3F45405B;
sub.f32 f1152, f1150, f1151;
mul.f32 f1153, f1057, 0fBF232E38;
fma.rn.f32 f1154, f1040, 0f3F45405B, f1153;
mul.f32 f1155, f1082, 0fBF7DFB3B;
mul.f32 f1156, f1099, 0f3E00575B;
sub.f32 f1157, f1155, f1156;
mul.f32 f1158, f1099, 0fBF7DFB3B;
fma.rn.f32 f1159, f1082, 0f3E00575B, f1158;
mul.f32 f1160, f948, 0f3F092BF2;
mul.f32 f1161, f965, 0f3F5825E0;
sub.f32 f1162, f1160, f1161;
mul.f32 f1163, f965, 0f3F092BF2;
fma.rn.f32 f1164, f948, 0f3F5825E0, f1163;
mul.f32 f1165, f990, 0fBED9FFBE;
mul.f32 f1166, f1007, 0f3F67A2BF;
sub.f32 f1167, f1165, f1166;
mul.f32 f1168, f1007, 0fBED9FFBE;
fma.rn.f32 f1169, f990, 0f3F67A2BF, f1168;
mul.f32 f1170, f1032, 0fBF7DFB3B;
mul.f32 f1171, f1049, 0f3E00575B;
sub.f32 f1172, f1170, f1171;
mul.f32 f1173, f1049, 0fBF7DFB3B;
fma.rn.f32 f1174, f1032, 0f3E00575B, f1173;
mul.f32 f1175, f1074, 0fBF232E38;
mul.f32 f1176, f1091, 0fBF45405B;
sub.f32 f1177, f1175, f1176;
mul.f32 f1178, f1091, 0fBF232E38;
fma.rn.f32 f1179, f1074, 0fBF45405B, f1178;
add.f32 f1180, f935, f1061;
add.f32 f1181, f893, f1180;
add.f32 f1182, f977, f1019;
add.f32 f1183, f939, f1065;
add.f32 f1184, f897, f1183;
add.f32 f1185, f981, f1023;
fma.rn.f32 f1186, f1180, 0f3E9E377A, f893;
mul.f32 f1187, f1182, 0f3F4F1BBD;
sub.f32 f1188, f1186, f1187;
sub.f32 f1189, f939, f1065;
mul.f32 f1190, f1189, 0f3F737871;
sub.f32 f1191, f981, f1023;
fma.rn.f32 f1192, f1191, 0f3F167918, f1190;
mul.f32 f1193, f1180, 0f3F4F1BBD;
sub.f32 f1194, f893, f1193;
fma.rn.f32 f1195, f1182, 0f3E9E377A, f1194;
mul.f32 f1196, f1189, 0f3F167918;
mul.f32 f1197, f1191, 0f3F737871;
sub.f32 f1198, f1196, f1197;
fma.rn.f32 f1199, f1183, 0f3E9E377A, f897;
mul.f32 f1200, f1185, 0f3F4F1BBD;
sub.f32 f1201, f1199, f1200;
sub.f32 f1202, f935, f1061;
mul.f32 f1203, f1202, 0f3F737871;
sub.f32 f1204, f977, f1019;
fma.rn.f32 f1205, f1204, 0f3F167918, f1203;
mul.f32 f1206, f1183, 0f3F4F1BBD;
sub.f32 f1207, f897, f1206;
fma.rn.f32 f1208, f1185, 0f3E9E377A, f1207;
mul.f32 f1209, f1202, 0f3F167918;
mul.f32 f1210, f1204, 0f3F737871;
sub.f32 f1211, f1209, f1210;
add.f32 f1212, f1102, f1117;
add.f32 f1213, f905, f1212;
add.f32 f1214, f1107, f1112;
add.f32 f1215, f1104, f1119;
add.f32 f1216, f922, f1215;
add.f32 f1217, f1109, f1114;
fma.rn.f32 f1218, f1212, 0f3E9E377A, f905;
mul.f32 f1219, f1214, 0f3F4F1BBD;
sub.f32 f1220, f1218, f1219;
sub.f32 f1221, f1104, f1119;
mul.f32 f1222, f1221, 0f3F737871;
sub.f32 f1223, f1109, f1114;
fma.rn.f32 f1224, f1223, 0f3F167918, f1222;
mul.f32 f1225, f1212, 0f3F4F1BBD;
sub.f32 f1226, f905, f1225;
fma.rn.f32 f1227, f1214, 0f3E9E377A, f1226;
mul.f32 f1228, f1221, 0f3F167918;
mul.f32 f1229, f1223, 0f3F737871;
sub.f32 f1230, f1228, f1229;
fma.rn.f32 f1231, f1215, 0f3E9E377A, f922;
mul.f32 f1232, f1217, 0f3F4F1BBD;
sub.f32 f1233, f1231, f1232;
sub.f32 f1234, f1102, f1117;
mul.f32 f1235, f1234, 0f3F737871;
sub.f32 f1236, f1107, f1112;
fma.rn.f32 f1237, f1236, 0f3F167918, f1235;
mul.f32 f1238, f1215, 0f3F4F1BBD;
sub.f32 f1239, f922, f1238;
fma.rn.f32 f1240, f1217, 0f3E9E377A, f1239;
mul.f32 f1241, f1234, 0f3F167918;
mul.f32 f1242, f1236, 0f3F737871;
sub.f32 f1243, f1241, f1242;
add.f32 f1244, f1122, f1137;
add.f32 f1245, f913, f1244;
add.f32 f1246, f1127, f1132;
add.f32 f1247, f1124, f1139;
add.f32 f1248, f930, f1247;
add.f32 f1249, f1129, f1134;
fma.rn.f32 f1250, f1244, 0f3E9E377A, f913;
mul.f32 f1251, f1246, 0f3F4F1BBD;
sub.f32 f1252, f1250, f1251;
sub.f32 f1253, f1124, f1139;
mul.f32 f1254, f1253, 0f3F737871;
sub.f32 f1255, f1129, f1134;
fma.rn.f32 f1256, f1255, 0f3F167918, f1254;
mul.f32 f1257, f1244, 0f3F4F1BBD;
sub.f32 f1258, f913, f1257;
fma.rn.f32 f1259, f1246, 0f3E9E377A, f1258;
mul.f32 f1260, f1253, 0f3F167918;
mul.f32 f1261, f1255, 0f3F737871;
sub.f32 f1262, f1260, f1261;
fma.rn.f32 f1263, f1247, 0f3E9E377A, f930;
mul.f32 f1264, f1249, 0f3F4F1BBD;
sub.f32 f1265, f1263, f1264;
sub.f32 f1266, f1122, f1137;
mul.f32 f1267, f1266, 0f3F737871;
sub.f32 f1268, f1127, f1132;
fma.rn.f32 f1269, f1268, 0f3F167918, f1267;
mul.f32 f1270, f1247, 0f3F4F1BBD;
sub.f32 f1271, f930, f1270;
fma.rn.f32 f1272, f1249, 0f3E9E377A, f1271;
mul.f32 f1273, f1266, 0f3F167918;
mul.f32 f1274, f1268, 0f3F737871;
sub.f32 f1275, f1273, f1274;
add.f32 f1276, f1142, f1157;
add.f32 f1277, f914, f1276;
add.f32 f1278, f1147, f1152;
add.f32 f1279, f1144, f1159;
add.f32 f1280, f931, f1279;
add.f32 f1281, f1149, f1154;
fma.rn.f32 f1282, f1276, 0f3E9E377A, f914;
mul.f32 f1283, f1278, 0f3F4F1BBD;
sub.f32 f1284, f1282, f1283;
sub.f32 f1285, f1144, f1159;
mul.f32 f1286, f1285, 0f3F737871;
sub.f32 f1287, f1149, f1154;
fma.rn.f32 f1288, f1287, 0f3F167918, f1286;
mul.f32 f1289, f1276, 0f3F4F1BBD;
sub.f32 f1290, f914, f1289;
fma.rn.f32 f1291, f1278, 0f3E9E377A, f1290;
mul.f32 f1292, f1285, 0f3F167918;
mul.f32 f1293, f1287, 0f3F737871;
sub.f32 f1294, f1292, f1293;
fma.rn.f32 f1295, f1279, 0f3E9E377A, f931;
mul.f32 f1296, f1281, 0f3F4F1BBD;
sub.f32 f1297, f1295, f1296;
sub.f32 f1298, f1142, f1157;
mul.f32 f1299, f1298, 0f3F737871;
sub.f32 f1300, f1147, f1152;
fma.rn.f32 f1301, f1300, 0f3F167918, f1299;
mul.f32 f1302, f1279, 0f3F4F1BBD;
sub.f32 f1303, f931, f1302;
fma.rn.f32 f1304, f1281, 0f3E9E377A, f1303;
mul.f32 f1305, f1298, 0f3F167918;
mul.f32 f1306, f1300, 0f3F737871;
sub.f32 f1307, f1305, f1306;
add.f32 f1308, f1162, f1177;
add.f32 f1309, f906, f1308;
add.f32 f1310, f1167, f1172;
add.f32 f1311, f1164, f1179;
add.f32 f1312, f923, f1311;
add.f32 f1313, f1169, f1174;
fma.rn.f32 f1314, f1308, 0f3E9E377A, f906;
mul.f32 f1315, f1310, 0f3F4F1BBD;
sub.f32 f1316, f1314, f1315;
sub.f32 f1317, f1164, f1179;
mul.f32 f1318, f1317, 0f3F737871;
sub.f32 f1319, f1169, f1174;
fma.rn.f32 f1320, f1319, 0f3F167918, f1318;
mul.f32 f1321, f1308, 0f3F4F1BBD;
sub.f32 f1322, f906, f1321;
fma.rn.f32 f1323, f1310, 0f3E9E377A, f1322;
mul.f32 f1324, f1317, 0f3F167918;
mul.f32 f1325, f1319, 0f3F737871;
sub.f32 f1326, f1324, f1325;
fma.rn.f32 f1327, f1311, 0f3E9E377A, f923;
mul.f32 f1328, f1313, 0f3F4F1BBD;
sub.f32 f1329, f1327, f1328;
sub.f32 f1330, f1162, f1177;
mul.f32 f1331, f1330, 0f3F737871;
sub.f32 f1332, f1167, f1172;
fma.rn.f32 f1333, f1332, 0f3F167918, f1331;
mul.f32 f1334, f1311, 0f3F4F1BBD;
sub.f32 f1335, f923, f1334;
fma.rn.f32 f1336, f1313, 0f3E9E377A, f1335;
mul.f32 f1337, f1330, 0f3F167918;
mul.f32 f1338, f1332, 0f3F737871;
sub.f32 f1339, f1337, f1338;
add.f32 %0, f1182, f1181;
add.f32 %1, f1185, f1184;
add.f32 %3, f1217, f1216;
add.f32 %2, f1214, f1213;
add.f32 %5, f1249, f1248;
add.f32 %4, f1246, f1245;
add.f32 %7, f1281, f1280;
add.f32 %6, f1278, f1277;
add.f32 %9, f1313, f1312;
add.f32 %8, f1310, f1309;
add.f32 %11, f1205, f1201;
sub.f32 %10, f1188, f1192;
add.f32 %13, f1237, f1233;
sub.f32 %12, f1220, f1224;
add.f32 %15, f1269, f1265;
sub.f32 %14, f1252, f1256;
add.f32 %17, f1301, f1297;
sub.f32 %16, f1284, f1288;
add.f32 %19, f1333, f1329;
sub.f32 %18, f1316, f1320;
sub.f32 %20, f1195, f1198;
add.f32 %21, f1211, f1208;
add.f32 %23, f1243, f1240;
sub.f32 %22, f1227, f1230;
add.f32 %25, f1275, f1272;
sub.f32 %24, f1259, f1262;
add.f32 %27, f1307, f1304;
sub.f32 %26, f1291, f1294;
add.f32 %29, f1339, f1336;
sub.f32 %28, f1323, f1326;
add.f32 %30, f1198, f1195;
sub.f32 %31, f1208, f1211;
sub.f32 %33, f1240, f1243;
add.f32 %32, f1230, f1227;
sub.f32 %35, f1272, f1275;
add.f32 %34, f1262, f1259;
sub.f32 %37, f1304, f1307;
add.f32 %36, f1294, f1291;
sub.f32 %39, f1336, f1339;
add.f32 %38, f1326, f1323;
sub.f32 %41, f1201, f1205;
add.f32 %40, f1192, f1188;
sub.f32 %43, f1233, f1237;
add.f32 %42, f1224, f1220;
sub.f32 %45, f1265, f1269;
add.f32 %44, f1256, f1252;
sub.f32 %47, f1297, f1301;
add.f32 %46, f1288, f1284;
sub.f32 %49, f1329, f1333;
add.f32 %48, f1320, f1316;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y), "=f"(rmem[5].x), "=f"(rmem[5].y), "=f"(rmem[6].x), "=f"(rmem[6].y), "=f"(rmem[7].x), "=f"(rmem[7].y), "=f"(rmem[8].x), "=f"(rmem[8].y), "=f"(rmem[9].x), "=f"(rmem[9].y), "=f"(rmem[10].x), "=f"(rmem[10].y), "=f"(rmem[11].x), "=f"(rmem[11].y), "=f"(rmem[12].x), "=f"(rmem[12].y), "=f"(rmem[13].x), "=f"(rmem[13].y), "=f"(rmem[14].x), "=f"(rmem[14].y), "=f"(rmem[15].x), "=f"(rmem[15].y), "=f"(rmem[16].x), "=f"(rmem[16].y), "=f"(rmem[17].x), "=f"(rmem[17].y), "=f"(rmem[18].x), "=f"(rmem[18].y), "=f"(rmem[19].x), "=f"(rmem[19].y), "=f"(rmem[20].x), "=f"(rmem[20].y), "=f"(rmem[21].x), "=f"(rmem[21].y), "=f"(rmem[22].x), "=f"(rmem[22].y), "=f"(rmem[23].x), "=f"(rmem[23].y), "=f"(rmem[24].x), "=f"(rmem[24].y): "r"(smem), "l"(lut_sp_25_625), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y), "f"(rmem[4].y), "f"(rmem[5].x), "f"(rmem[5].y), "f"(rmem[5].y), "f"(rmem[6].x), "f"(rmem[6].y), "f"(rmem[7].x), "f"(rmem[7].y), "f"(rmem[7].y), "f"(rmem[8].x), "f"(rmem[8].y), "f"(rmem[8].y), "f"(rmem[9].x), "f"(rmem[9].y), "f"(rmem[10].x), "f"(rmem[10].y), "f"(rmem[10].y), "f"(rmem[11].x), "f"(rmem[11].y), "f"(rmem[11].y), "f"(rmem[12].x), "f"(rmem[12].y), "f"(rmem[13].x), "f"(rmem[13].y), "f"(rmem[13].y), "f"(rmem[14].x), "f"(rmem[14].y), "f"(rmem[14].y), "f"(rmem[15].x), "f"(rmem[15].y), "f"(rmem[16].x), "f"(rmem[16].y), "f"(rmem[16].y), "f"(rmem[17].x), "f"(rmem[17].y), "f"(rmem[17].y), "f"(rmem[18].x), "f"(rmem[18].y), "f"(rmem[19].x), "f"(rmem[19].y), "f"(rmem[19].y), "f"(rmem[20].x), "f"(rmem[20].y), "f"(rmem[20].y), "f"(rmem[21].x), "f"(rmem[21].y), "f"(rmem[22].x), "f"(rmem[22].y), "f"(rmem[22].y), "f"(rmem[23].x), "f"(rmem[23].y), "f"(rmem[23].y), "f"(rmem[24].x), "f"(rmem[24].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<366, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<366>;
.reg .b32 r<24>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 5000, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %16, %24;
add.f32 f22, %14, f21;
add.f32 f23, %19, %22;
add.f32 f24, %18, %25;
add.f32 f25, %15, f24;
add.f32 f26, %21, %23;
fma.rn.f32 f27, f21, 0f3E9E377A, %14;
mul.f32 f28, f23, 0f3F4F1BBD;
sub.f32 f29, f27, f28;
sub.f32 f30, %18, %25;
mul.f32 f31, f30, 0f3F737871;
sub.f32 f32, %21, %23;
fma.rn.f32 f33, f32, 0f3F167918, f31;
sub.f32 f34, f29, f33;
add.f32 f35, f33, f29;
mul.f32 f36, f21, 0f3F4F1BBD;
sub.f32 f37, %14, f36;
fma.rn.f32 f38, f23, 0f3E9E377A, f37;
mul.f32 f39, f30, 0f3F167918;
mul.f32 f40, f32, 0f3F737871;
sub.f32 f41, f39, f40;
sub.f32 f42, f38, f41;
add.f32 f43, f41, f38;
fma.rn.f32 f44, f24, 0f3E9E377A, %15;
mul.f32 f45, f26, 0f3F4F1BBD;
sub.f32 f46, f44, f45;
sub.f32 f47, %16, %24;
mul.f32 f48, f47, 0f3F737871;
sub.f32 f49, %19, %22;
fma.rn.f32 f50, f49, 0f3F167918, f48;
add.f32 f51, f50, f46;
sub.f32 f52, f46, f50;
mul.f32 f53, f24, 0f3F4F1BBD;
sub.f32 f54, %15, f53;
fma.rn.f32 f55, f26, 0f3E9E377A, f54;
mul.f32 f56, f47, 0f3F167918;
mul.f32 f57, f49, 0f3F737871;
sub.f32 f58, f56, f57;
add.f32 f59, f58, f55;
sub.f32 f60, f55, f58;
mul.wide.u32 rd2, r4, 274877907;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 125;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 5000, r3;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f61, f62}, [rd6];
mul.f32 f65, f51, f62;
mul.f32 f66, f34, f62;
mul.f32 f67, f61, f51;
mul.f32 f68, f61, f61;
mul.f32 f69, f62, f62;
sub.f32 f70, f68, f69;
mul.f32 f71, f62, f61;
fma.rn.f32 f72, f62, f61, f71;
mul.f32 f73, f59, f72;
mul.f32 f74, f42, f72;
mul.f32 f75, f70, f59;
mul.f32 f76, f61, f70;
mul.f32 f77, f62, f72;
sub.f32 f78, f76, f77;
mul.f32 f79, f61, f72;
fma.rn.f32 f80, f62, f70, f79;
mul.f32 f81, f60, f80;
mul.f32 f82, f43, f80;
mul.f32 f83, f78, f60;
mul.f32 f84, f61, f78;
mul.f32 f85, f62, f80;
sub.f32 f86, f84, f85;
mul.f32 f87, f61, f80;
fma.rn.f32 f88, f62, f78, f87;
mul.f32 f89, f52, f88;
mul.f32 f90, f35, f88;
mul.f32 f91, f86, f52;
barrier.sync 0;
mad.lo.s32 r9, r7, 40, r8;
add.f32 f92, f26, f25;
add.f32 f93, f23, f22;
st.shared.v2.f32 [r9], {f93, f92};
fma.rn.f32 f94, f61, f34, f65;
sub.f32 f95, f67, f66;
st.shared.v2.f32 [r9+8], {f94, f95};
fma.rn.f32 f96, f70, f42, f73;
sub.f32 f97, f75, f74;
st.shared.v2.f32 [r9+16], {f96, f97};
sub.f32 f98, f83, f82;
fma.rn.f32 f99, f78, f43, f81;
st.shared.v2.f32 [r9+24], {f99, f98};
fma.rn.f32 f100, f86, f35, f89;
sub.f32 f101, f91, f90;
st.shared.v2.f32 [r9+32], {f100, f101};
barrier.sync 0;
shl.b32 r10, r7, 5;
sub.s32 r11, r9, r10;
ld.shared.v2.f32 {f102, f103}, [r11];
ld.shared.v2.f32 {f106, f107}, [r11+1000];
ld.shared.v2.f32 {f110, f111}, [r11+2000];
ld.shared.v2.f32 {f114, f115}, [r11+3000];
ld.shared.v2.f32 {f118, f119}, [r11+4000];
add.f32 f122, f106, f118;
add.f32 f123, f102, f122;
add.f32 f124, f110, f114;
add.f32 f125, f107, f119;
add.f32 f126, f103, f125;
add.f32 f127, f111, f115;
fma.rn.f32 f128, f122, 0f3E9E377A, f102;
mul.f32 f129, f124, 0f3F4F1BBD;
sub.f32 f130, f128, f129;
sub.f32 f131, f107, f119;
mul.f32 f132, f131, 0f3F737871;
sub.f32 f133, f111, f115;
fma.rn.f32 f134, f133, 0f3F167918, f132;
sub.f32 f135, f130, f134;
add.f32 f136, f134, f130;
mul.f32 f137, f122, 0f3F4F1BBD;
sub.f32 f138, f102, f137;
fma.rn.f32 f139, f124, 0f3E9E377A, f138;
mul.f32 f140, f131, 0f3F167918;
mul.f32 f141, f133, 0f3F737871;
sub.f32 f142, f140, f141;
sub.f32 f143, f139, f142;
add.f32 f144, f142, f139;
fma.rn.f32 f145, f125, 0f3E9E377A, f103;
mul.f32 f146, f127, 0f3F4F1BBD;
sub.f32 f147, f145, f146;
sub.f32 f148, f106, f118;
mul.f32 f149, f148, 0f3F737871;
sub.f32 f150, f110, f114;
fma.rn.f32 f151, f150, 0f3F167918, f149;
add.f32 f152, f151, f147;
sub.f32 f153, f147, f151;
mul.f32 f154, f125, 0f3F4F1BBD;
sub.f32 f155, f103, f154;
fma.rn.f32 f156, f127, 0f3E9E377A, f155;
mul.f32 f157, f148, 0f3F167918;
mul.f32 f158, f150, 0f3F737871;
sub.f32 f159, f157, f158;
add.f32 f160, f159, f156;
sub.f32 f161, f156, f159;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f162, f163}, [rd11];
mul.f32 f166, f152, f163;
mul.f32 f167, f135, f163;
mul.f32 f168, f162, f152;
mul.f32 f169, f162, f162;
mul.f32 f170, f163, f163;
sub.f32 f171, f169, f170;
mul.f32 f172, f163, f162;
fma.rn.f32 f173, f163, f162, f172;
mul.f32 f174, f160, f173;
mul.f32 f175, f143, f173;
mul.f32 f176, f171, f160;
mul.f32 f177, f162, f171;
mul.f32 f178, f163, f173;
sub.f32 f179, f177, f178;
mul.f32 f180, f162, f173;
fma.rn.f32 f181, f163, f171, f180;
mul.f32 f182, f161, f181;
mul.f32 f183, f144, f181;
mul.f32 f184, f179, f161;
mul.f32 f185, f162, f179;
mul.f32 f186, f163, f181;
sub.f32 f187, f185, f186;
mul.f32 f188, f162, f181;
fma.rn.f32 f189, f163, f179, f188;
mul.f32 f190, f153, f189;
mul.f32 f191, f136, f189;
mul.f32 f192, f187, f153;
shl.b32 r15, r14, 3;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 200, r16;
add.f32 f193, f127, f126;
add.f32 f194, f124, f123;
st.shared.v2.f32 [r17], {f194, f193};
fma.rn.f32 f195, f162, f135, f166;
sub.f32 f196, f168, f167;
st.shared.v2.f32 [r17+40], {f195, f196};
fma.rn.f32 f197, f171, f143, f174;
sub.f32 f198, f176, f175;
st.shared.v2.f32 [r17+80], {f197, f198};
fma.rn.f32 f199, f179, f144, f182;
sub.f32 f200, f184, f183;
st.shared.v2.f32 [r17+120], {f199, f200};
fma.rn.f32 f201, f187, f136, f190;
sub.f32 f202, f192, f191;
st.shared.v2.f32 [r17+160], {f201, f202};
barrier.sync 0;
ld.shared.v2.f32 {f203, f204}, [r11];
ld.shared.v2.f32 {f207, f208}, [r11+1000];
ld.shared.v2.f32 {f211, f212}, [r11+2000];
ld.shared.v2.f32 {f215, f216}, [r11+3000];
ld.shared.v2.f32 {f219, f220}, [r11+4000];
add.f32 f223, f207, f219;
add.f32 f224, f203, f223;
add.f32 f225, f211, f215;
add.f32 f226, f208, f220;
add.f32 f227, f204, f226;
add.f32 f228, f212, f216;
fma.rn.f32 f229, f223, 0f3E9E377A, f203;
mul.f32 f230, f225, 0f3F4F1BBD;
sub.f32 f231, f229, f230;
sub.f32 f232, f208, f220;
mul.f32 f233, f232, 0f3F737871;
sub.f32 f234, f212, f216;
fma.rn.f32 f235, f234, 0f3F167918, f233;
sub.f32 f236, f231, f235;
add.f32 f237, f235, f231;
mul.f32 f238, f223, 0f3F4F1BBD;
sub.f32 f239, f203, f238;
fma.rn.f32 f240, f225, 0f3E9E377A, f239;
mul.f32 f241, f232, 0f3F167918;
mul.f32 f242, f234, 0f3F737871;
sub.f32 f243, f241, f242;
sub.f32 f244, f240, f243;
add.f32 f245, f243, f240;
fma.rn.f32 f246, f226, 0f3E9E377A, f204;
mul.f32 f247, f228, 0f3F4F1BBD;
sub.f32 f248, f246, f247;
sub.f32 f249, f207, f219;
mul.f32 f250, f249, 0f3F737871;
sub.f32 f251, f211, f215;
fma.rn.f32 f252, f251, 0f3F167918, f250;
add.f32 f253, f252, f248;
sub.f32 f254, f248, f252;
mul.f32 f255, f226, 0f3F4F1BBD;
sub.f32 f256, f204, f255;
fma.rn.f32 f257, f228, 0f3E9E377A, f256;
mul.f32 f258, f249, 0f3F167918;
mul.f32 f259, f251, 0f3F737871;
sub.f32 f260, f258, f259;
add.f32 f261, f260, f257;
sub.f32 f262, f257, f260;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 35;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 25;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 8;
mov.u64 rd15, %13;
add.s64 rd16, rd15, rd14;
ld.global.v2.f32 {f263, f264}, [rd16];
mul.f32 f267, f253, f264;
mul.f32 f268, f236, f264;
mul.f32 f269, f263, f253;
mul.f32 f270, f263, f263;
mul.f32 f271, f264, f264;
sub.f32 f272, f270, f271;
mul.f32 f273, f264, f263;
fma.rn.f32 f274, f264, f263, f273;
mul.f32 f275, f261, f274;
mul.f32 f276, f244, f274;
mul.f32 f277, f272, f261;
mul.f32 f278, f263, f272;
mul.f32 f279, f264, f274;
sub.f32 f280, f278, f279;
mul.f32 f281, f263, f274;
fma.rn.f32 f282, f264, f272, f281;
mul.f32 f283, f262, f282;
mul.f32 f284, f245, f282;
mul.f32 f285, f280, f262;
mul.f32 f286, f263, f280;
mul.f32 f287, f264, f282;
sub.f32 f288, f286, f287;
mul.f32 f289, f263, f282;
fma.rn.f32 f290, f264, f280, f289;
mul.f32 f291, f254, f290;
mul.f32 f292, f237, f290;
mul.f32 f293, f288, f254;
shl.b32 r21, r20, 3;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 1000, r22;
add.f32 f294, f228, f227;
add.f32 f295, f225, f224;
st.shared.v2.f32 [r23], {f295, f294};
fma.rn.f32 f296, f263, f236, f267;
sub.f32 f297, f269, f268;
st.shared.v2.f32 [r23+200], {f296, f297};
fma.rn.f32 f298, f272, f244, f275;
sub.f32 f299, f277, f276;
st.shared.v2.f32 [r23+400], {f298, f299};
fma.rn.f32 f300, f280, f245, f283;
sub.f32 f301, f285, f284;
st.shared.v2.f32 [r23+600], {f300, f301};
fma.rn.f32 f302, f288, f237, f291;
sub.f32 f303, f293, f292;
st.shared.v2.f32 [r23+800], {f302, f303};
barrier.sync 0;
ld.shared.v2.f32 {f304, f305}, [r11];
ld.shared.v2.f32 {f308, f309}, [r11+1000];
ld.shared.v2.f32 {f312, f313}, [r11+2000];
ld.shared.v2.f32 {f316, f317}, [r11+3000];
ld.shared.v2.f32 {f320, f321}, [r11+4000];
add.f32 f324, f308, f320;
add.f32 f325, f304, f324;
add.f32 f326, f312, f316;
add.f32 f327, f309, f321;
add.f32 f328, f305, f327;
add.f32 f329, f313, f317;
fma.rn.f32 f330, f324, 0f3E9E377A, f304;
mul.f32 f331, f326, 0f3F4F1BBD;
sub.f32 f332, f330, f331;
sub.f32 f333, f309, f321;
mul.f32 f334, f333, 0f3F737871;
sub.f32 f335, f313, f317;
fma.rn.f32 f336, f335, 0f3F167918, f334;
mul.f32 f337, f324, 0f3F4F1BBD;
sub.f32 f338, f304, f337;
fma.rn.f32 f339, f326, 0f3E9E377A, f338;
mul.f32 f340, f333, 0f3F167918;
mul.f32 f341, f335, 0f3F737871;
sub.f32 f342, f340, f341;
fma.rn.f32 f343, f327, 0f3E9E377A, f305;
mul.f32 f344, f329, 0f3F4F1BBD;
sub.f32 f345, f343, f344;
sub.f32 f346, f308, f320;
mul.f32 f347, f346, 0f3F737871;
sub.f32 f348, f312, f316;
fma.rn.f32 f349, f348, 0f3F167918, f347;
mul.f32 f350, f327, 0f3F4F1BBD;
sub.f32 f351, f305, f350;
fma.rn.f32 f352, f329, 0f3E9E377A, f351;
mul.f32 f353, f346, 0f3F167918;
mul.f32 f354, f348, 0f3F737871;
sub.f32 f355, f353, f354;
add.f32 %1, f329, f328;
add.f32 %0, f326, f325;
add.f32 %3, f349, f345;
sub.f32 %2, f332, f336;
add.f32 %5, f355, f352;
sub.f32 %4, f339, f342;
sub.f32 %7, f352, f355;
add.f32 %6, f342, f339;
sub.f32 %9, f345, f349;
add.f32 %8, f336, f332;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_625), "l"(lut_sp_5_125), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<367, float, 1>(cufftdx::detail::complex<float> *rmem, unsigned smem){

asm volatile (R"({
.reg .f32 f<336>;
.reg .b32 r<24>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %10;
mad.lo.s32 r3, r1, 2500, r2;
mov.u32 r4, %tid.x;
add.f32 f21, %16, %24;
add.f32 f22, %14, f21;
add.f32 f23, %19, %22;
add.f32 f24, f23, f22;
add.f32 f25, %18, %25;
add.f32 f26, %15, f25;
add.f32 f27, %21, %23;
add.f32 f28, f27, f26;
fma.rn.f32 f29, f21, 0f3E9E377A, %14;
mul.f32 f30, f23, 0f3F4F1BBD;
sub.f32 f31, f29, f30;
sub.f32 f32, %18, %25;
mul.f32 f33, f32, 0f3F737871;
sub.f32 f34, %21, %23;
fma.rn.f32 f35, f34, 0f3F167918, f33;
sub.f32 f36, f31, f35;
add.f32 f37, f35, f31;
mul.f32 f38, f21, 0f3F4F1BBD;
sub.f32 f39, %14, f38;
fma.rn.f32 f40, f23, 0f3E9E377A, f39;
mul.f32 f41, f32, 0f3F167918;
mul.f32 f42, f34, 0f3F737871;
sub.f32 f43, f41, f42;
sub.f32 f44, f40, f43;
add.f32 f45, f43, f40;
fma.rn.f32 f46, f25, 0f3E9E377A, %15;
mul.f32 f47, f27, 0f3F4F1BBD;
sub.f32 f48, f46, f47;
sub.f32 f49, %16, %24;
mul.f32 f50, f49, 0f3F737871;
sub.f32 f51, %19, %22;
fma.rn.f32 f52, f51, 0f3F167918, f50;
add.f32 f53, f52, f48;
sub.f32 f54, f48, f52;
mul.f32 f55, f25, 0f3F4F1BBD;
sub.f32 f56, %15, f55;
fma.rn.f32 f57, f27, 0f3E9E377A, f56;
mul.f32 f58, f49, 0f3F167918;
mul.f32 f59, f51, 0f3F737871;
sub.f32 f60, f58, f59;
add.f32 f61, f60, f57;
sub.f32 f62, f57, f60;
mul.wide.u32 rd2, r4, 274877907;
shr.u64 rd3, rd2, 35;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 125;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 8;
mov.u64 rd5, %11;
add.s64 rd6, rd5, rd4;
ld.global.v2.f32 {f63, f64}, [rd6];
mul.f32 f67, f53, f64;
fma.rn.f32 f68, f63, f36, f67;
mul.f32 f69, f36, f64;
mul.f32 f70, f63, f53;
sub.f32 f71, f70, f69;
mul.f32 f72, f63, f63;
mul.f32 f73, f64, f64;
sub.f32 f74, f72, f73;
mul.f32 f75, f64, f63;
fma.rn.f32 f76, f64, f63, f75;
mul.f32 f77, f61, f76;
fma.rn.f32 f78, f74, f44, f77;
mul.f32 f79, f44, f76;
mul.f32 f80, f74, f61;
sub.f32 f81, f80, f79;
mul.f32 f82, f63, f74;
mul.f32 f83, f64, f76;
sub.f32 f84, f82, f83;
mul.f32 f85, f63, f76;
fma.rn.f32 f86, f64, f74, f85;
mul.f32 f87, f62, f86;
fma.rn.f32 f88, f84, f45, f87;
mul.f32 f89, f45, f86;
mul.f32 f90, f84, f62;
sub.f32 f91, f90, f89;
mul.f32 f92, f63, f84;
mul.f32 f93, f64, f86;
sub.f32 f94, f92, f93;
mul.f32 f95, f63, f86;
fma.rn.f32 f96, f64, f84, f95;
mul.f32 f97, f54, f96;
fma.rn.f32 f98, f94, f37, f97;
mul.f32 f99, f37, f96;
mul.f32 f100, f94, f54;
sub.f32 f101, f100, f99;
mad.lo.s32 r8, r5, 2500, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 20, r8;
st.shared.f32 [r9], f24;
st.shared.f32 [r9+4], f68;
st.shared.f32 [r9+8], f78;
st.shared.f32 [r9+12], f88;
st.shared.f32 [r9+16], f98;
barrier.sync 0;
shl.b32 r10, r7, 4;
sub.s32 r11, r9, r10;
ld.shared.f32 f102, [r11];
ld.shared.f32 f103, [r11+500];
ld.shared.f32 f104, [r11+1000];
ld.shared.f32 f105, [r11+1500];
ld.shared.f32 f106, [r11+2000];
barrier.sync 0;
st.shared.f32 [r9], f28;
st.shared.f32 [r9+4], f71;
st.shared.f32 [r9+8], f81;
st.shared.f32 [r9+12], f91;
st.shared.f32 [r9+16], f101;
barrier.sync 0;
ld.shared.f32 f107, [r11];
ld.shared.f32 f108, [r11+500];
ld.shared.f32 f109, [r11+1000];
ld.shared.f32 f110, [r11+1500];
ld.shared.f32 f111, [r11+2000];
add.f32 f112, f103, f106;
add.f32 f113, f102, f112;
add.f32 f114, f104, f105;
add.f32 f115, f114, f113;
add.f32 f116, f108, f111;
add.f32 f117, f107, f116;
add.f32 f118, f109, f110;
add.f32 f119, f118, f117;
fma.rn.f32 f120, f112, 0f3E9E377A, f102;
mul.f32 f121, f114, 0f3F4F1BBD;
sub.f32 f122, f120, f121;
sub.f32 f123, f108, f111;
mul.f32 f124, f123, 0f3F737871;
sub.f32 f125, f109, f110;
fma.rn.f32 f126, f125, 0f3F167918, f124;
sub.f32 f127, f122, f126;
add.f32 f128, f126, f122;
mul.f32 f129, f112, 0f3F4F1BBD;
sub.f32 f130, f102, f129;
fma.rn.f32 f131, f114, 0f3E9E377A, f130;
mul.f32 f132, f123, 0f3F167918;
mul.f32 f133, f125, 0f3F737871;
sub.f32 f134, f132, f133;
sub.f32 f135, f131, f134;
add.f32 f136, f134, f131;
fma.rn.f32 f137, f116, 0f3E9E377A, f107;
mul.f32 f138, f118, 0f3F4F1BBD;
sub.f32 f139, f137, f138;
sub.f32 f140, f103, f106;
mul.f32 f141, f140, 0f3F737871;
sub.f32 f142, f104, f105;
fma.rn.f32 f143, f142, 0f3F167918, f141;
add.f32 f144, f143, f139;
sub.f32 f145, f139, f143;
mul.f32 f146, f116, 0f3F4F1BBD;
sub.f32 f147, f107, f146;
fma.rn.f32 f148, f118, 0f3E9E377A, f147;
mul.f32 f149, f140, 0f3F167918;
mul.f32 f150, f142, 0f3F737871;
sub.f32 f151, f149, f150;
add.f32 f152, f151, f148;
sub.f32 f153, f148, f151;
mul.wide.u32 rd7, r7, -858993459;
shr.u64 rd8, rd7, 34;
cvt.u32.u64 r12, rd8;
mul.lo.s32 r13, r12, 5;
sub.s32 r14, r7, r13;
mul.wide.u32 rd9, r12, 8;
mov.u64 rd10, %12;
add.s64 rd11, rd10, rd9;
ld.global.v2.f32 {f154, f155}, [rd11];
mul.f32 f158, f144, f155;
fma.rn.f32 f159, f154, f127, f158;
mul.f32 f160, f127, f155;
mul.f32 f161, f154, f144;
sub.f32 f162, f161, f160;
mul.f32 f163, f154, f154;
mul.f32 f164, f155, f155;
sub.f32 f165, f163, f164;
mul.f32 f166, f155, f154;
fma.rn.f32 f167, f155, f154, f166;
mul.f32 f168, f152, f167;
fma.rn.f32 f169, f165, f135, f168;
mul.f32 f170, f135, f167;
mul.f32 f171, f165, f152;
sub.f32 f172, f171, f170;
mul.f32 f173, f154, f165;
mul.f32 f174, f155, f167;
sub.f32 f175, f173, f174;
mul.f32 f176, f154, f167;
fma.rn.f32 f177, f155, f165, f176;
mul.f32 f178, f153, f177;
fma.rn.f32 f179, f175, f136, f178;
mul.f32 f180, f136, f177;
mul.f32 f181, f175, f153;
sub.f32 f182, f181, f180;
mul.f32 f183, f154, f175;
mul.f32 f184, f155, f177;
sub.f32 f185, f183, f184;
mul.f32 f186, f154, f177;
fma.rn.f32 f187, f155, f175, f186;
mul.f32 f188, f145, f187;
fma.rn.f32 f189, f185, f128, f188;
mul.f32 f190, f128, f187;
mul.f32 f191, f185, f145;
sub.f32 f192, f191, f190;
shl.b32 r15, r14, 2;
add.s32 r16, r8, r15;
barrier.sync 0;
mad.lo.s32 r17, r12, 100, r16;
st.shared.f32 [r17], f115;
st.shared.f32 [r17+20], f159;
st.shared.f32 [r17+40], f169;
st.shared.f32 [r17+60], f179;
st.shared.f32 [r17+80], f189;
barrier.sync 0;
ld.shared.f32 f193, [r11];
ld.shared.f32 f194, [r11+500];
ld.shared.f32 f195, [r11+1000];
ld.shared.f32 f196, [r11+1500];
ld.shared.f32 f197, [r11+2000];
barrier.sync 0;
st.shared.f32 [r17], f119;
st.shared.f32 [r17+20], f162;
st.shared.f32 [r17+40], f172;
st.shared.f32 [r17+60], f182;
st.shared.f32 [r17+80], f192;
barrier.sync 0;
ld.shared.f32 f198, [r11];
ld.shared.f32 f199, [r11+500];
ld.shared.f32 f200, [r11+1000];
ld.shared.f32 f201, [r11+1500];
ld.shared.f32 f202, [r11+2000];
add.f32 f203, f194, f197;
add.f32 f204, f193, f203;
add.f32 f205, f195, f196;
add.f32 f206, f205, f204;
add.f32 f207, f199, f202;
add.f32 f208, f198, f207;
add.f32 f209, f200, f201;
add.f32 f210, f209, f208;
fma.rn.f32 f211, f203, 0f3E9E377A, f193;
mul.f32 f212, f205, 0f3F4F1BBD;
sub.f32 f213, f211, f212;
sub.f32 f214, f199, f202;
mul.f32 f215, f214, 0f3F737871;
sub.f32 f216, f200, f201;
fma.rn.f32 f217, f216, 0f3F167918, f215;
sub.f32 f218, f213, f217;
add.f32 f219, f217, f213;
mul.f32 f220, f203, 0f3F4F1BBD;
sub.f32 f221, f193, f220;
fma.rn.f32 f222, f205, 0f3E9E377A, f221;
mul.f32 f223, f214, 0f3F167918;
mul.f32 f224, f216, 0f3F737871;
sub.f32 f225, f223, f224;
sub.f32 f226, f222, f225;
add.f32 f227, f225, f222;
fma.rn.f32 f228, f207, 0f3E9E377A, f198;
mul.f32 f229, f209, 0f3F4F1BBD;
sub.f32 f230, f228, f229;
sub.f32 f231, f194, f197;
mul.f32 f232, f231, 0f3F737871;
sub.f32 f233, f195, f196;
fma.rn.f32 f234, f233, 0f3F167918, f232;
add.f32 f235, f234, f230;
sub.f32 f236, f230, f234;
mul.f32 f237, f207, 0f3F4F1BBD;
sub.f32 f238, f198, f237;
fma.rn.f32 f239, f209, 0f3E9E377A, f238;
mul.f32 f240, f231, 0f3F167918;
mul.f32 f241, f233, 0f3F737871;
sub.f32 f242, f240, f241;
add.f32 f243, f242, f239;
sub.f32 f244, f239, f242;
mul.wide.u32 rd12, r7, 1374389535;
shr.u64 rd13, rd12, 35;
cvt.u32.u64 r18, rd13;
mul.lo.s32 r19, r18, 25;
sub.s32 r20, r7, r19;
mul.wide.u32 rd14, r18, 8;
mov.u64 rd15, %13;
add.s64 rd16, rd15, rd14;
ld.global.v2.f32 {f245, f246}, [rd16];
mul.f32 f249, f235, f246;
fma.rn.f32 f250, f245, f218, f249;
mul.f32 f251, f218, f246;
mul.f32 f252, f245, f235;
sub.f32 f253, f252, f251;
mul.f32 f254, f245, f245;
mul.f32 f255, f246, f246;
sub.f32 f256, f254, f255;
mul.f32 f257, f246, f245;
fma.rn.f32 f258, f246, f245, f257;
mul.f32 f259, f243, f258;
fma.rn.f32 f260, f256, f226, f259;
mul.f32 f261, f226, f258;
mul.f32 f262, f256, f243;
sub.f32 f263, f262, f261;
mul.f32 f264, f245, f256;
mul.f32 f265, f246, f258;
sub.f32 f266, f264, f265;
mul.f32 f267, f245, f258;
fma.rn.f32 f268, f246, f256, f267;
mul.f32 f269, f244, f268;
fma.rn.f32 f270, f266, f227, f269;
mul.f32 f271, f227, f268;
mul.f32 f272, f266, f244;
sub.f32 f273, f272, f271;
mul.f32 f274, f245, f266;
mul.f32 f275, f246, f268;
sub.f32 f276, f274, f275;
mul.f32 f277, f245, f268;
fma.rn.f32 f278, f246, f266, f277;
mul.f32 f279, f236, f278;
fma.rn.f32 f280, f276, f219, f279;
mul.f32 f281, f219, f278;
mul.f32 f282, f276, f236;
sub.f32 f283, f282, f281;
shl.b32 r21, r20, 2;
add.s32 r22, r8, r21;
barrier.sync 0;
mad.lo.s32 r23, r18, 500, r22;
st.shared.f32 [r23], f206;
st.shared.f32 [r23+100], f250;
st.shared.f32 [r23+200], f260;
st.shared.f32 [r23+300], f270;
st.shared.f32 [r23+400], f280;
barrier.sync 0;
ld.shared.f32 f284, [r11];
ld.shared.f32 f285, [r11+500];
ld.shared.f32 f286, [r11+1000];
ld.shared.f32 f287, [r11+1500];
ld.shared.f32 f288, [r11+2000];
barrier.sync 0;
st.shared.f32 [r23], f210;
st.shared.f32 [r23+100], f253;
st.shared.f32 [r23+200], f263;
st.shared.f32 [r23+300], f273;
st.shared.f32 [r23+400], f283;
barrier.sync 0;
ld.shared.f32 f289, [r11];
ld.shared.f32 f290, [r11+500];
ld.shared.f32 f291, [r11+1000];
ld.shared.f32 f292, [r11+1500];
ld.shared.f32 f293, [r11+2000];
add.f32 f294, f285, f288;
add.f32 f295, f284, f294;
add.f32 f296, f286, f287;
add.f32 f297, f290, f293;
add.f32 f298, f289, f297;
add.f32 f299, f291, f292;
fma.rn.f32 f300, f294, 0f3E9E377A, f284;
mul.f32 f301, f296, 0f3F4F1BBD;
sub.f32 f302, f300, f301;
sub.f32 f303, f290, f293;
mul.f32 f304, f303, 0f3F737871;
sub.f32 f305, f291, f292;
fma.rn.f32 f306, f305, 0f3F167918, f304;
mul.f32 f307, f294, 0f3F4F1BBD;
sub.f32 f308, f284, f307;
fma.rn.f32 f309, f296, 0f3E9E377A, f308;
mul.f32 f310, f303, 0f3F167918;
mul.f32 f311, f305, 0f3F737871;
sub.f32 f312, f310, f311;
fma.rn.f32 f313, f297, 0f3E9E377A, f289;
mul.f32 f314, f299, 0f3F4F1BBD;
sub.f32 f315, f313, f314;
sub.f32 f316, f285, f288;
mul.f32 f317, f316, 0f3F737871;
sub.f32 f318, f286, f287;
fma.rn.f32 f319, f318, 0f3F167918, f317;
mul.f32 f320, f297, 0f3F4F1BBD;
sub.f32 f321, f289, f320;
fma.rn.f32 f322, f299, 0f3E9E377A, f321;
mul.f32 f323, f316, 0f3F167918;
mul.f32 f324, f318, 0f3F737871;
sub.f32 f325, f323, f324;
add.f32 %0, f296, f295;
add.f32 %1, f299, f298;
add.f32 %3, f319, f315;
sub.f32 %2, f302, f306;
sub.f32 %4, f309, f312;
add.f32 %5, f325, f322;
add.f32 %6, f312, f309;
sub.f32 %7, f322, f325;
sub.f32 %9, f315, f319;
add.f32 %8, f306, f302;
})"
     : "=f"(rmem[0].x), "=f"(rmem[0].y), "=f"(rmem[1].x), "=f"(rmem[1].y), "=f"(rmem[2].x), "=f"(rmem[2].y), "=f"(rmem[3].x), "=f"(rmem[3].y), "=f"(rmem[4].x), "=f"(rmem[4].y): "r"(smem), "l"(lut_sp_5_625), "l"(lut_sp_5_125), "l"(lut_sp_5_25), "f"(rmem[0].x), "f"(rmem[0].y), "f"(rmem[1].x), "f"(rmem[1].y), "f"(rmem[1].y), "f"(rmem[2].x), "f"(rmem[2].y), "f"(rmem[2].y), "f"(rmem[3].x), "f"(rmem[3].y), "f"(rmem[4].x), "f"(rmem[4].y));
};


#endif
